/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter;

import org.geotools.filter.spatial.BBOXImpl;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.GeometryProcessing;
import org.locationtech.geomesa.filter.GeometryProcessing$;
import org.locationtech.geomesa.filter.GeometryProcessing$AbstractGeometryProcessing$;
import org.locationtech.geomesa.filter.expression.AttributeExpression;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Within;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.Nothing$;

public abstract class GeometryProcessing$AbstractGeometryProcessing$class {
    public static Filter process(GeometryProcessing.AbstractGeometryProcessing $this, BinarySpatialOperator op, SimpleFeatureType sft, FilterFactory2 factory) {
        BinarySpatialOperator binarySpatialOperator;
        AttributeExpression prop = package$.MODULE$.checkOrderUnsafe(op.getExpression1(), op.getExpression2());
        Geometry geom = (Geometry)FastConverter$.MODULE$.evaluate((Expression)prop.literal(), Geometry.class);
        Object object = geom.getUserData();
        String string = GeometryProcessing$.MODULE$.org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            binarySpatialOperator = op;
        } else {
            String attribute2 = (String)Option$.MODULE$.apply((Object)prop.name()).filterNot((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.isEmpty();
                }
            }).orElse((Function0)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final Option<String> apply() {
                    return Option$.MODULE$.apply((Object)this.sft$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(SimpleFeatureType x$2) {
                            return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(x$2));
                        }
                    });
                }
                {
                    this.sft$1 = sft$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            Geometry trimmedGeom = FilterHelper$.MODULE$.trimToWorld(geom);
            if (trimmedGeom.isEmpty()) {
                binarySpatialOperator = Filter.EXCLUDE;
            } else {
                PropertyName property = factory.property(attribute2);
                Seq filters = (Seq)GeometryProcessing$.MODULE$.org$locationtech$geomesa$filter$GeometryProcessing$$flatten($this.split(trimmedGeom, op)).map((Function1)new Serializable($this, prop, property, op, factory){
                    public static final long serialVersionUID = 0L;
                    private final AttributeExpression prop$1;
                    private final PropertyName property$1;
                    private final BinarySpatialOperator op$1;
                    private final FilterFactory2 factory$1;

                    public final BinarySpatialOperator apply(Geometry geom) {
                        Tuple2 tuple2;
                        block2: {
                            BinarySpatialOperator binarySpatialOperator;
                            block9: {
                                Within within;
                                block4: {
                                    Expression e2;
                                    Expression e1;
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block3: {
                                                        Tuple2 tuple22;
                                                        geom.setUserData((Object)GeometryProcessing$.MODULE$.org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString());
                                                        Literal literal = this.factory$1.literal((Object)geom);
                                                        Tuple2 tuple23 = tuple2 = this.prop$1.flipped() ? new Tuple2((Object)literal, (Object)this.property$1) : new Tuple2((Object)this.property$1, (Object)literal);
                                                        if (tuple2 == null) break block2;
                                                        Expression e12 = (Expression)tuple2._1();
                                                        Expression e22 = (Expression)tuple2._2();
                                                        Tuple2 tuple24 = tuple22 = new Tuple2((Object)e12, (Object)e22);
                                                        e1 = (Expression)tuple24._1();
                                                        e2 = (Expression)tuple24._2();
                                                        binarySpatialOperator = this.op$1;
                                                        if (!(binarySpatialOperator instanceof Within)) break block3;
                                                        within = this.factory$1.within(e1, e2);
                                                        break block4;
                                                    }
                                                    if (!(binarySpatialOperator instanceof Intersects)) break block5;
                                                    within = this.factory$1.intersects(e1, e2);
                                                    break block4;
                                                }
                                                if (!(binarySpatialOperator instanceof Overlaps)) break block6;
                                                within = this.factory$1.overlaps(e1, e2);
                                                break block4;
                                            }
                                            if (!(binarySpatialOperator instanceof DWithin)) break block7;
                                            DWithin dWithin = (DWithin)binarySpatialOperator;
                                            within = this.factory$1.dwithin(e1, e2, dWithin.getDistance(), dWithin.getDistanceUnits());
                                            break block4;
                                        }
                                        if (!(binarySpatialOperator instanceof BBOX)) break block8;
                                        within = new BBOXImpl(e1, e2);
                                        break block4;
                                    }
                                    if (!(binarySpatialOperator instanceof Contains)) break block9;
                                    within = this.factory$1.contains(e1, e2);
                                }
                                return within;
                            }
                            throw new MatchError((Object)binarySpatialOperator);
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.prop$1 = prop$1;
                        this.property$1 = property$1;
                        this.op$1 = op$1;
                        this.factory$1 = factory$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                binarySpatialOperator = package$.MODULE$.orFilters((Seq<Filter>)filters, (FilterFactory)factory);
            }
        }
        return binarySpatialOperator;
    }

    public static Seq extract(GeometryProcessing.AbstractGeometryProcessing $this, BinarySpatialOperator op, String attribute2) {
        Option geometry = package$.MODULE$.checkOrder(op.getExpression1(), op.getExpression2()).withFilter((Function1)new Serializable($this, attribute2){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(AttributeExpression prop) {
                if (prop.name() == null) return true;
                String string = prop.name();
                String string2 = this.attribute$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.attribute$1 = attribute$1;
            }
        }).flatMap((Function1)new Serializable($this, op){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeometryProcessing.AbstractGeometryProcessing $outer;
            public final BinarySpatialOperator op$2;

            public final Option<Geometry> apply(AttributeExpression prop) {
                return Option$.MODULE$.apply(FastConverter$.MODULE$.evaluate((Expression)prop.literal(), Geometry.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GeometryProcessing$AbstractGeometryProcessing$.anonfun.5 $outer;

                    public final Geometry apply(Geometry geom) {
                        Geometry geometry;
                        BinarySpatialOperator binarySpatialOperator = this.$outer.op$2;
                        if (binarySpatialOperator instanceof DWithin) {
                            DWithin dWithin = (DWithin)binarySpatialOperator;
                            geometry = geom.buffer(GeometryUtils$.MODULE$.distanceDegrees(geom, dWithin.getDistance() * GeometryProcessing$.MODULE$.metersMultiplier(dWithin.getDistanceUnits()))._2$mcD$sp());
                        } else {
                            geometry = geom;
                        }
                        Geometry buffered = geometry;
                        return this.$outer.org$locationtech$geomesa$filter$GeometryProcessing$AbstractGeometryProcessing$$anonfun$$$outer().split(FilterHelper$.MODULE$.trimToWorld(buffered), this.$outer.op$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GeometryProcessing.AbstractGeometryProcessing org$locationtech$geomesa$filter$GeometryProcessing$AbstractGeometryProcessing$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$2 = op$2;
            }
        });
        return (Seq)geometry.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Geometry> apply(Geometry geometry) {
                return GeometryProcessing$.MODULE$.org$locationtech$geomesa$filter$GeometryProcessing$$flatten(geometry);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public static void $init$(GeometryProcessing.AbstractGeometryProcessing $this) {
    }
}

