/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;

public abstract class TrigonometricFn
extends ExtensionFunctionDefinition {
    private static StructuredQName SIN = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "sin");
    private static StructuredQName COS = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "cos");
    private static StructuredQName TAN = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "tan");
    private static StructuredQName ASIN = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "asin");
    private static StructuredQName ACOS = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "acos");
    private static StructuredQName ATAN = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "atan");
    private static StructuredQName SQRT = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "sqrt");
    private static StructuredQName LOG = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "log");
    private static StructuredQName LOG10 = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "log10");
    private static StructuredQName EXP = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "exp");
    private static StructuredQName EXP10 = new StructuredQName("math", "http://www.w3.org/2005/xpath-functions/math", "exp10");

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_DOUBLE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_DOUBLE;
    }

    protected abstract double compute(double var1);

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            @Override
            public ZeroOrOne<DoubleValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
                DoubleValue arg = (DoubleValue)arguments[0].head();
                if (arg == null) {
                    return ZeroOrOne.empty();
                }
                double result = TrigonometricFn.this.compute(arg.getDoubleValue());
                return new ZeroOrOne<DoubleValue>(new DoubleValue(result));
            }
        };
    }

    public static class Exp10Fn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return EXP10;
        }

        protected double compute(double input) {
            return Math.pow(10.0, input);
        }
    }

    public static class ExpFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return EXP;
        }

        protected double compute(double input) {
            return Math.exp(input);
        }
    }

    public static class Log10Fn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return LOG10;
        }

        protected double compute(double input) {
            return Math.log10(input);
        }
    }

    public static class LogFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return LOG;
        }

        protected double compute(double input) {
            return Math.log(input);
        }
    }

    public static class SqrtFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return SQRT;
        }

        protected double compute(double input) {
            return Math.sqrt(input);
        }
    }

    public static class AtanFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ATAN;
        }

        protected double compute(double input) {
            return Math.atan(input);
        }
    }

    public static class AcosFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ACOS;
        }

        protected double compute(double input) {
            return Math.acos(input);
        }
    }

    public static class AsinFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ASIN;
        }

        protected double compute(double input) {
            return Math.asin(input);
        }
    }

    public static class TanFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return TAN;
        }

        protected double compute(double input) {
            return Math.tan(input);
        }
    }

    public static class CosFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return COS;
        }

        protected double compute(double input) {
            return Math.cos(input);
        }
    }

    public static class SinFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return SIN;
        }

        protected double compute(double input) {
            return Math.sin(input);
        }
    }
}

