/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLPackage
extends XSLModuleRoot {
    private boolean prepared = false;
    private String nameAtt = null;
    private PackageVersion packageVersion = null;
    private boolean declaredModes = true;

    public void initialise(NodeName elemName, SchemaType elementType, AttributeCollectionImpl atts, NodeInfo parent, int sequenceNumber) {
        super.initialise(elemName, elementType, atts, parent, sequenceNumber);
        this.declaredModes = this.getLocalPart().equals("package");
    }

    public String getName() {
        if (this.nameAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.nameAtt = "default";
            }
        }
        return this.nameAtt;
    }

    public int getVersion() {
        if (this.version == -1) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.version = 30;
            }
        }
        return this.version;
    }

    public PackageVersion getPackageVersion() {
        if (this.packageVersion == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.packageVersion = PackageVersion.ONE;
            }
        }
        return this.packageVersion;
    }

    protected void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        String inputTypeAnnotationsAtt = null;
        String packageVersionAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name") && this.getLocalPart().equals("package")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("id")) continue;
            if (f.equals("version")) {
                if (this.version != -1) continue;
                this.processVersionAttribute("");
                continue;
            }
            if (f.equals("package-version") && this.getLocalPart().equals("package")) {
                packageVersionAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("declared-modes") && this.getLocalPart().equals("package")) {
                this.declaredModes = this.processBooleanAttribute("declared-modes", atts.getValue(a));
                continue;
            }
            if (f.equals("default-validation")) {
                String val = Whitespace.trim(atts.getValue(a));
                this.defaultValidation = Validation.getCode(val);
                if (this.defaultValidation == -1 || this.defaultValidation == 1 || this.defaultValidation == 2) {
                    this.compileError("Invalid value for default-validation attribute. Permitted values are (preserve, strip)", "XTSE0020");
                    continue;
                }
                if (this.isSchemaAware() || this.defaultValidation == 4) continue;
                this.defaultValidation = 4;
                this.compileError("default-validation='" + val + "' requires a schema-aware processor", "XTSE1660");
                continue;
            }
            if (f.equals("input-type-annotations")) {
                inputTypeAnnotationsAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (packageVersionAtt == null) {
            this.packageVersion = PackageVersion.ONE;
        } else {
            try {
                this.packageVersion = new PackageVersion(packageVersionAtt);
            }
            catch (XPathException e) {
                this.packageVersion = PackageVersion.ONE;
                this.compileErrorInAttribute(e.getMessage(), e.getErrorCodeLocalPart(), "package-version");
            }
        }
        if (this.version == -1) {
            this.version = 30;
            this.reportAbsence("version");
        }
        if (!(inputTypeAnnotationsAtt == null || inputTypeAnnotationsAtt.equals("strip") || inputTypeAnnotationsAtt.equals("preserve") || inputTypeAnnotationsAtt.equals("unspecified"))) {
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return false;
    }

    public boolean isDeclaredModes() {
        if (this.nameAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.nameAtt = null;
            }
        }
        return this.declaredModes;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeImpl child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)kids.next()) != null) {
            int fp = child.getFingerprint();
            if (child.getNodeKind() == 3 || child instanceof StyleElement && ((StyleElement)child).isDeclaration() || child instanceof DataElement || this.getLocalPart().equals("package") && (fp == 204 || fp == 152) || !"http://www.w3.org/1999/XSL/Transform".equals(child.getURI()) && !"".equals(child.getURI()) || child instanceof AbsentExtensionElement && ((StyleElement)child).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(child.getURI())) {
                ((StyleElement)child).compileError("Element " + child.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)child).compileError("Element " + child.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }
}

