/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.PatternOptimization;
import net.sf.saxon.trans.PackageLibrary;

public class CompilerInfo {
    private transient URIResolver uriResolver;
    private transient OutputURIResolver outputURIResolver = StandardOutputResolver.getInstance();
    private transient ErrorListener errorListener;
    private CodeInjector codeInjector;
    private int recoveryPolicy = 1;
    private boolean schemaAware;
    private boolean versionWarning;
    private String messageReceiverClassName = "net.sf.saxon.serialize.MessageEmitter";
    private StructuredQName defaultInitialMode;
    private StructuredQName defaultInitialTemplate;
    private int xsltVersion = 0;
    private FunctionLibrary extensionFunctionLibrary;
    private GlobalParameterSet variableList = new GlobalParameterSet();
    private String defaultCollation;
    private PackageLibrary packageLibrary = new PackageLibrary();
    private boolean generateByteCode = false;
    private boolean assertionsEnabled = false;
    private String targetEdition = "HE";
    private PatternOptimization patternOptimization;

    public CompilerInfo() {
    }

    public CompilerInfo(CompilerInfo info) {
        this.copyFrom(info);
    }

    public void copyFrom(CompilerInfo info) {
        this.uriResolver = info.uriResolver;
        this.outputURIResolver = info.outputURIResolver;
        this.errorListener = info.errorListener;
        this.codeInjector = info.codeInjector;
        this.recoveryPolicy = info.recoveryPolicy;
        this.schemaAware = info.schemaAware;
        this.versionWarning = info.versionWarning;
        this.messageReceiverClassName = info.messageReceiverClassName;
        this.defaultInitialMode = info.defaultInitialMode;
        this.defaultInitialTemplate = info.defaultInitialTemplate;
        this.xsltVersion = info.xsltVersion;
        this.packageLibrary = info.packageLibrary;
        this.generateByteCode = info.generateByteCode;
        this.extensionFunctionLibrary = info.extensionFunctionLibrary;
        this.defaultCollation = info.defaultCollation;
        this.assertionsEnabled = info.assertionsEnabled;
        this.targetEdition = info.targetEdition;
        this.patternOptimization = info.patternOptimization;
        this.variableList = new GlobalParameterSet(info.variableList);
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void setParameter(StructuredQName name, Sequence seq) {
        this.variableList.put(name, seq);
    }

    public GlobalParameterSet getParameters() {
        return this.variableList;
    }

    public void clearParameters() {
        this.variableList.clear();
    }

    public void setTargetEdition(String edition) {
        this.targetEdition = edition;
    }

    public String getTargetEdition() {
        return this.targetEdition;
    }

    public void setPackageLibrary(PackageLibrary library) {
        this.packageLibrary = library;
    }

    public PackageLibrary getPackageLibrary() {
        return this.packageLibrary;
    }

    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    public void setAssertionsEnabled(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public void setGenerateByteCode(boolean option) {
        this.generateByteCode = option;
    }

    public boolean isGenerateByteCode() {
        return this.generateByteCode;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public String getMessageReceiverClassName() {
        return this.messageReceiverClassName;
    }

    public void setMessageReceiverClassName(String messageReceiverClassName) {
        this.messageReceiverClassName = messageReceiverClassName;
    }

    public void setDefaultCollation(String collation) {
        this.defaultCollation = collation;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector != null;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public PatternOptimization getPatternOptimization() {
        return this.patternOptimization;
    }

    public void setPatternOptimization(PatternOptimization p) {
        this.patternOptimization = p;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean warn) {
        this.versionWarning = warn;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setDefaultInitialTemplate(StructuredQName initialTemplate) {
        this.defaultInitialTemplate = initialTemplate;
    }

    public StructuredQName getDefaultInitialTemplate() {
        return this.defaultInitialTemplate;
    }

    public void setDefaultInitialMode(StructuredQName initialMode) {
        this.defaultInitialMode = initialMode;
    }

    public StructuredQName getDefaultInitialMode() {
        return this.defaultInitialMode;
    }

    public void setXsltVersion(int version) {
        if (version == 10) {
            this.xsltVersion = 20;
        } else {
            if (version != 20 && version != 30 && version != 0) {
                throw new IllegalArgumentException("XSLT version must be 0.0, 2.0 or 3.0");
            }
            this.xsltVersion = version;
        }
    }

    public int getXsltVersion() {
        return this.xsltVersion;
    }

    public void setExtensionFunctionLibrary(FunctionLibrary library) {
        this.extensionFunctionLibrary = library;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return this.extensionFunctionLibrary;
    }
}

