/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.expr.instruct.ComponentCode;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.QNameTest;

public class ComponentTest {
    private int componentKind;
    private QNameTest nameTest;
    private int arity;

    public ComponentTest(int componentKind, QNameTest nameTest, int arity) {
        this.componentKind = componentKind;
        this.nameTest = nameTest;
        this.arity = arity;
    }

    public int getComponentKind() {
        return this.componentKind;
    }

    public QNameTest getQNameTest() {
        return this.nameTest;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isPartialWildcard() {
        return this.nameTest instanceof LocalNameTest || this.nameTest instanceof NamespaceTest;
    }

    public boolean matches(ComponentCode component) {
        return !(this.componentKind != -1 && component.getComponentKind() != this.componentKind || !this.nameTest.matches(component.getObjectName()) || this.componentKind == 158 && this.arity != -1 && this.arity != ((UserFunction)component).getArity());
    }

    public boolean equals(Object other) {
        return other instanceof ComponentTest && ((ComponentTest)other).componentKind == this.componentKind && ((ComponentTest)other).arity == this.arity && ((ComponentTest)other).nameTest.equals(this.nameTest);
    }

    public int hashCode() {
        return this.componentKind ^ this.arity ^ this.nameTest.hashCode();
    }
}

