/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListIterator
implements UnfailingIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator,
ReversibleIterator {
    int index = 0;
    int length;
    List<? extends Item> list;

    public ListIterator(List<? extends Item> list) {
        this.list = list;
        this.length = list.size();
    }

    public ListIterator(List<? extends Item> list, int length) {
        this.list = list;
        this.length = length;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public Item next() {
        if (this.index >= this.length) {
            this.index = -1;
            this.length = -1;
            return null;
        }
        return this.list.get(this.index++);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ListIterator getAnother() {
        return new ListIterator(this.list);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public GroundedValue materialize() {
        if (this.length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.length == 1) {
            Item item = this.list.get(0);
            if (item instanceof GroundedValue) {
                return (GroundedValue)((Object)item);
            }
            return new One<Item>(item);
        }
        return new SequenceExtent(this.list);
    }

    @Override
    public GroundedValue getResidue() throws XPathException {
        if (this.index == 0) {
            return this.materialize();
        }
        return this.materialize().subsequence(this.index, Integer.MAX_VALUE);
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new ReverseListIterator(this.list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Atomic
    extends ListIterator
    implements AtomicIterator {
        public Atomic(List<AtomicValue> list) {
            super(list);
        }

        @Override
        public AtomicValue next() {
            return (AtomicValue)super.next();
        }

        @Override
        public Atomic getAnother() {
            return new Atomic(this.list);
        }
    }
}

