/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.StaticProperty;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public final class SequenceType {
    private ItemType primaryType;
    private int cardinality;
    private static Map<ItemType, SequenceType[]> pool = new ConcurrentHashMap<ItemType, SequenceType[]>(50);
    public static final SequenceType ANY_SEQUENCE = SequenceType.makeSequenceType(AnyItemType.getInstance(), 57344);
    public static final SequenceType SINGLE_ITEM = SequenceType.makeSequenceType(AnyItemType.getInstance(), 16384);
    public static final SequenceType OPTIONAL_ITEM = SequenceType.makeSequenceType(AnyItemType.getInstance(), 24576);
    public static final SequenceType SINGLE_ATOMIC = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 16384);
    public static final SequenceType OPTIONAL_ATOMIC = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 24576);
    public static final SequenceType ATOMIC_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344);
    public static final SequenceType SINGLE_STRING = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, 16384);
    public static final SequenceType SINGLE_UNTYPED_ATOMIC = SequenceType.makeSequenceType(BuiltInAtomicType.UNTYPED_ATOMIC, 16384);
    public static final SequenceType OPTIONAL_STRING = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, 24576);
    public static final SequenceType SINGLE_BOOLEAN = SequenceType.makeSequenceType(BuiltInAtomicType.BOOLEAN, 16384);
    public static final SequenceType OPTIONAL_BOOLEAN = SequenceType.makeSequenceType(BuiltInAtomicType.BOOLEAN, 24576);
    public static final SequenceType SINGLE_INTEGER = SequenceType.makeSequenceType(BuiltInAtomicType.INTEGER, 16384);
    public static final SequenceType SINGLE_DECIMAL = SequenceType.makeSequenceType(BuiltInAtomicType.DECIMAL, 16384);
    public static final SequenceType OPTIONAL_INTEGER = SequenceType.makeSequenceType(BuiltInAtomicType.INTEGER, 24576);
    public static final SequenceType SINGLE_LONG = SequenceType.makeSequenceType(BuiltInAtomicType.LONG, 16384);
    public static final SequenceType SINGLE_ANY_URI = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_URI, 16384);
    public static final SequenceType OPTIONAL_LONG = SequenceType.makeSequenceType(BuiltInAtomicType.LONG, 24576);
    public static final SequenceType SINGLE_INT = SequenceType.makeSequenceType(BuiltInAtomicType.INT, 16384);
    public static final SequenceType OPTIONAL_INT = SequenceType.makeSequenceType(BuiltInAtomicType.INT, 24576);
    public static final SequenceType SINGLE_SHORT = SequenceType.makeSequenceType(BuiltInAtomicType.SHORT, 16384);
    public static final SequenceType OPTIONAL_SHORT = SequenceType.makeSequenceType(BuiltInAtomicType.SHORT, 24576);
    public static final SequenceType SINGLE_BYTE = SequenceType.makeSequenceType(BuiltInAtomicType.BYTE, 16384);
    public static final SequenceType OPTIONAL_BYTE = SequenceType.makeSequenceType(BuiltInAtomicType.BYTE, 24576);
    public static final SequenceType SINGLE_DOUBLE = SequenceType.makeSequenceType(BuiltInAtomicType.DOUBLE, 16384);
    public static final SequenceType OPTIONAL_DOUBLE = SequenceType.makeSequenceType(BuiltInAtomicType.DOUBLE, 24576);
    public static final SequenceType SINGLE_FLOAT = SequenceType.makeSequenceType(BuiltInAtomicType.FLOAT, 16384);
    public static final SequenceType OPTIONAL_FLOAT = SequenceType.makeSequenceType(BuiltInAtomicType.FLOAT, 24576);
    public static final SequenceType OPTIONAL_DECIMAL = SequenceType.makeSequenceType(BuiltInAtomicType.DECIMAL, 24576);
    public static final SequenceType OPTIONAL_ANY_URI = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_URI, 24576);
    public static final SequenceType OPTIONAL_DATE = SequenceType.makeSequenceType(BuiltInAtomicType.DATE, 24576);
    public static final SequenceType OPTIONAL_TIME = SequenceType.makeSequenceType(BuiltInAtomicType.TIME, 24576);
    public static final SequenceType OPTIONAL_G_YEAR = SequenceType.makeSequenceType(BuiltInAtomicType.G_YEAR, 24576);
    public static final SequenceType OPTIONAL_G_YEAR_MONTH = SequenceType.makeSequenceType(BuiltInAtomicType.G_YEAR_MONTH, 24576);
    public static final SequenceType OPTIONAL_G_MONTH = SequenceType.makeSequenceType(BuiltInAtomicType.G_MONTH, 24576);
    public static final SequenceType OPTIONAL_G_MONTH_DAY = SequenceType.makeSequenceType(BuiltInAtomicType.G_MONTH_DAY, 24576);
    public static final SequenceType OPTIONAL_G_DAY = SequenceType.makeSequenceType(BuiltInAtomicType.G_DAY, 24576);
    public static final SequenceType OPTIONAL_DATE_TIME = SequenceType.makeSequenceType(BuiltInAtomicType.DATE_TIME, 24576);
    public static final SequenceType OPTIONAL_DURATION = SequenceType.makeSequenceType(BuiltInAtomicType.DURATION, 24576);
    public static final SequenceType OPTIONAL_YEAR_MONTH_DURATION = SequenceType.makeSequenceType(BuiltInAtomicType.YEAR_MONTH_DURATION, 24576);
    public static final SequenceType OPTIONAL_DAY_TIME_DURATION = SequenceType.makeSequenceType(BuiltInAtomicType.DAY_TIME_DURATION, 24576);
    public static final SequenceType SINGLE_QNAME = SequenceType.makeSequenceType(BuiltInAtomicType.QNAME, 16384);
    public static final SequenceType OPTIONAL_QNAME = SequenceType.makeSequenceType(BuiltInAtomicType.QNAME, 24576);
    public static final SequenceType OPTIONAL_NOTATION = SequenceType.makeSequenceType(BuiltInAtomicType.NOTATION, 24576);
    public static final SequenceType OPTIONAL_BASE64_BINARY = SequenceType.makeSequenceType(BuiltInAtomicType.BASE64_BINARY, 24576);
    public static final SequenceType OPTIONAL_HEX_BINARY = SequenceType.makeSequenceType(BuiltInAtomicType.HEX_BINARY, 24576);
    public static final SequenceType OPTIONAL_NUMERIC = SequenceType.makeSequenceType(NumericType.getInstance(), 24576);
    public static final SequenceType SINGLE_NUMERIC = SequenceType.makeSequenceType(NumericType.getInstance(), 16384);
    public static final SequenceType OPTIONAL_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 24576);
    public static final SequenceType SINGLE_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 16384);
    public static final SequenceType OPTIONAL_DOCUMENT_NODE = SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 24576);
    public static final SequenceType SINGLE_ELEMENT_NODE = SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 16384);
    public static final SequenceType OPTIONAL_ELEMENT_NODE = SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 24576);
    public static final SequenceType OPTIONAL_ATTRIBUTE_NODE = SequenceType.makeSequenceType(NodeKindTest.ATTRIBUTE, 24576);
    public static final SequenceType NODE_SEQUENCE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 57344);
    public static final SequenceType NUMERIC_SEQUENCE = SequenceType.makeSequenceType(NumericType.getInstance(), 57344);
    public static final SequenceType INTEGER_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.INTEGER, 57344);
    public static final SequenceType STRING_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, 57344);
    public static final SequenceType BASE64_BINARY_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.BASE64_BINARY, 57344);
    public static SequenceType SINGLE_FUNCTION = SequenceType.makeSequenceType(AnyFunctionType.ANY_FUNCTION, 16384);
    public static final SequenceType OPTIONAL_FUNCTION_ITEM = SequenceType.makeSequenceType(AnyFunctionType.getInstance(), 24576);
    public static final SequenceType EMPTY_SEQUENCE = SequenceType.makeSequenceType(ErrorType.getInstance(), 8192);
    public static final SequenceType NON_EMPTY_SEQUENCE = SequenceType.makeSequenceType(AnyItemType.getInstance(), 49152);
    public static final SequenceType VOID = SequenceType.makeSequenceType(ErrorType.getInstance(), 8192);

    private SequenceType(ItemType primaryType, int cardinality) {
        this.primaryType = primaryType;
        this.cardinality = primaryType instanceof ErrorType ? 8192 : cardinality;
    }

    public static SequenceType makeSequenceType(ItemType primaryType, int cardinality) {
        int code;
        if (!(primaryType instanceof BuiltInAtomicType)) {
            return new SequenceType(primaryType, cardinality);
        }
        SequenceType[] array = pool.get(primaryType);
        if (array == null) {
            array = new SequenceType[8];
            pool.put(primaryType, array);
        }
        if (array[code = StaticProperty.getCardinalityCode(cardinality)] == null) {
            SequenceType s;
            array[code] = s = new SequenceType(primaryType, cardinality);
            return s;
        }
        return array[code];
    }

    public ItemType getPrimaryType() {
        return this.primaryType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public boolean matches(Sequence value, TypeHierarchy th) throws XPathException {
        Item item;
        if (value instanceof Item) {
            return this.primaryType.matches((Item)value, th);
        }
        int count = 0;
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            ++count;
            if (this.primaryType.matches(item, th)) continue;
            return false;
        }
        return !(count == 0 && !Cardinality.allowsZero(this.cardinality) || count > 1 && !Cardinality.allowsMany(this.cardinality));
    }

    public String toString() {
        if (this.cardinality == 8192) {
            return "empty-sequence()";
        }
        return this.primaryType.toString() + Cardinality.getOccurrenceIndicator(this.cardinality);
    }

    public int hashCode() {
        return this.primaryType.hashCode() ^ this.cardinality;
    }

    public boolean equals(Object obj) {
        return obj instanceof SequenceType && this.primaryType.equals(((SequenceType)obj).primaryType) && this.cardinality == ((SequenceType)obj).cardinality;
    }
}

