/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.process.vector.TransformProcess;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryPlanner$$anonfun$org$locationtech$geomesa$index$planning$QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryPlanner$$anonfun$org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1$1$;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.index.utils.Reprojection$QueryReferenceSystems$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.stats.StatParser$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class QueryPlanner$
implements LazyLogging {
    public static final QueryPlanner$ MODULE$;
    private final SoftThreadLocal<Map<Object, Object>> threadedHints;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new QueryPlanner$();
    }

    private Logger logger$lzycompute() {
        QueryPlanner$ queryPlanner$ = this;
        synchronized (queryPlanner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SoftThreadLocal<Map<Object, Object>> threadedHints() {
        return this.threadedHints;
    }

    public void setPerThreadQueryHints(Map<Object, Object> hints) {
        this.threadedHints().put(hints);
    }

    public Option<Map<Object, Object>> getPerThreadQueryHints() {
        return this.threadedHints().get();
    }

    public void clearPerThreadQueryHints() {
        this.threadedHints().clear();
    }

    public void setQueryTransforms(Query query2, SimpleFeatureType sft) {
        Option$.MODULE$.apply((Object)query2.getPropertyNames()).map((Function1)new Serializable(query2){
            public static final long serialVersionUID = 0L;
            private final Query query$3;

            public final Seq<String> apply(String[] props) {
                return QueryPlanner$.MODULE$.org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1(props, this.query$3);
            }
            {
                this.query$3 = query$3;
            }
        }).filterNot((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final boolean apply(Seq<String> props) {
                return QueryPlanner$.MODULE$.org$locationtech$geomesa$index$planning$QueryPlanner$$noop$1(props, this.sft$2);
            }
            {
                this.sft$2 = sft$2;
            }
        }).orElse((Function0)new Serializable(query2, sft){
            public static final long serialVersionUID = 0L;
            private final Query query$3;
            private final SimpleFeatureType sft$2;

            public final Option<Seq<String>> apply() {
                return QueryPlanner$.MODULE$.org$locationtech$geomesa$index$planning$QueryPlanner$$fromQueryType$1(this.query$3, this.sft$2);
            }
            {
                this.query$3 = query$3;
                this.sft$2 = sft$2;
            }
        }).foreach((Function1)new Serializable(query2, sft){
            public static final long serialVersionUID = 0L;
            private final Query query$3;
            private final SimpleFeatureType sft$2;

            public final Object apply(Seq<String> props) {
                Tuple2<String, SimpleFeatureType> tuple2 = QueryPlanner$.MODULE$.buildTransformSFT(this.sft$2, props);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String transforms = (String)tuple2._1();
                    SimpleFeatureType derivedSchema = (SimpleFeatureType)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)transforms, (Object)derivedSchema);
                    String transforms2 = (String)tuple23._1();
                    SimpleFeatureType derivedSchema2 = (SimpleFeatureType)tuple23._2();
                    this.query$3.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORMS(), (Object)transforms2);
                    return this.query$3.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORM_SCHEMA(), (Object)derivedSchema2);
                }
                throw new MatchError(tuple2);
            }
            {
                this.query$3 = query$3;
                this.sft$2 = sft$2;
            }
        });
    }

    public Tuple2<String, SimpleFeatureType> buildTransformSFT(SimpleFeatureType sft, Seq<String> properties) {
        String transforms = ((TraversableOnce)properties.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return new StringOps(Predef$.MODULE$.augmentString(p)).contains((Object)BoxesRunTime.boxToCharacter((char)'=')) ? p : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p, p}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(";");
        List transformDefs = TransformProcess.toDefinition((String)transforms);
        SimpleFeatureType derivedSchema = this.computeSchema(sft, (Seq<TransformProcess.Definition>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(transformDefs).asScala()));
        return new Tuple2((Object)transforms, (Object)derivedSchema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setQuerySort(SimpleFeatureType sft, Query query2) {
        SortBy[] sortBy = query2.getSortBy();
        if (sortBy == null || !Predef$.MODULE$.refArrayOps((Object[])sortBy).nonEmpty()) return;
        Hints hints = query2.getHints();
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            if (Predef$.MODULE$.refArrayOps((Object[])sortBy).lengthCompare(1) > 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Arrow queries only support sort by a single field: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            }
            if (((SortBy)Predef$.MODULE$.refArrayOps((Object[])sortBy).head()).getPropertyName() == null) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Arrow queries only support sort by properties: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            }
            String field = ((SortBy)Predef$.MODULE$.refArrayOps((Object[])sortBy).head()).getPropertyName().getPropertyName();
            SortOrder sortOrder = ((SortBy)Predef$.MODULE$.refArrayOps((Object[])sortBy).head()).getSortOrder();
            SortOrder sortOrder2 = SortOrder.DESCENDING;
            boolean reverse = !(sortOrder != null ? !sortOrder.equals(sortOrder2) : sortOrder2 != null);
            QueryHints$.MODULE$.RichHints(hints).getArrowSort().foreach((Function1)new Serializable(sortBy, field, reverse){
                public static final long serialVersionUID = 0L;
                private final SortBy[] sortBy$1;
                private final String field$1;
                private final boolean reverse$1;

                public final void apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String f = (String)tuple2._1();
                        boolean r = tuple2._2$mcZ$sp();
                        String string = f;
                        String string2 = this.field$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null) && r == this.reverse$1) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query sort does not match Arrow hints sort: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " != ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.sortBy$1).mkString(", "), f, r ? "DESC" : "ASC"}))).toString());
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sortBy$1 = sortBy$1;
                    this.field$1 = field$1;
                    this.reverse$1 = reverse$1;
                }
            });
            hints.put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), (Object)field);
            hints.put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)reverse));
            return;
        } else if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            String dtg = (String)QueryHints$.MODULE$.RichHints(hints).getBinDtgField().orElse((Function0)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$4;

                public final Option<String> apply() {
                    return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$4));
                }
                {
                    this.sft$4 = sft$4;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            if (dtg == null) throw new IllegalArgumentException(new StringBuilder().append((Object)"BIN queries only support sort by a date-type field: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            Seq seq = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sortBy).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SortBy s) {
                    return (String)Option$.MODULE$.apply((Object)s.getPropertyName()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(PropertyName x$12) {
                            return x$12.getPropertyName();
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq();
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dtg}));
            if (seq != null ? !seq.equals(genTraversable) : genTraversable != null) throw new IllegalArgumentException(new StringBuilder().append((Object)"BIN queries only support sort by a date-type field: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            SortOrder sortOrder = ((SortBy)Predef$.MODULE$.refArrayOps((Object[])sortBy).head()).getSortOrder();
            SortOrder sortOrder3 = SortOrder.DESCENDING;
            if (!(sortOrder != null ? !sortOrder.equals(sortOrder3) : sortOrder3 != null)) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"BIN queries only support sort in ASCENDING order: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            }
            if (hints.get((Object)QueryHints$.MODULE$.BIN_SORT()) != null && !QueryHints$.MODULE$.RichHints(hints).isBinSorting()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Query sort order contradicts BIN sorting hint: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])sortBy).mkString(", ")).toString());
            hints.put((Object)QueryHints$.MODULE$.BIN_SORT(), (Object)Boolean.TRUE);
            return;
        } else {
            hints.put((Object)QueryHints$Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints$Internal$.MODULE$.toSortHint(sortBy));
        }
    }

    public void setProjection(SimpleFeatureType sft, Query query2) {
        Reprojection$QueryReferenceSystems$.MODULE$.apply(query2).foreach((Function1)new Serializable(query2){
            public static final long serialVersionUID = 0L;
            private final Query query$4;

            public final Object apply(Reprojection.QueryReferenceSystems crs) {
                return this.query$4.getHints().put((Object)QueryHints$Internal$.MODULE$.REPROJECTION(), (Object)QueryHints$Internal$.MODULE$.toProjectionHint(crs));
            }
            {
                this.query$4 = query$4;
            }
        });
    }

    public void setMaxFeatures(Query query2) {
        if (!query2.isMaxFeaturesUnlimited()) {
            query2.getHints().put((Object)QueryHints$Internal$.MODULE$.MAX_FEATURES(), (Object)BoxesRunTime.boxToInteger((int)query2.getMaxFeatures()));
        }
    }

    private SimpleFeatureType computeSchema(SimpleFeatureType sft, Seq<TransformProcess.Definition> transforms) {
        Seq descriptors = (Seq)transforms.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$3;

            public final AttributeDescriptor apply(TransformProcess.Definition definition) {
                block5: {
                    AttributeDescriptor attributeDescriptor;
                    block3: {
                        Expression expression;
                        block4: {
                            block2: {
                                expression = definition.expression;
                                if (!(expression instanceof PropertyName)) break block2;
                                PropertyName propertyName = (PropertyName)expression;
                                AttributeDescriptor originalDescriptor = (AttributeDescriptor)Option$.MODULE$.apply(propertyName.evaluate((Object)this.sft$3, AttributeDescriptor.class)).getOrElse((Function0)new Serializable(this, propertyName){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.7 $outer;
                                    private final PropertyName x2$1;

                                    public final Nothing$ apply() {
                                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1.getPropertyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not exist in schema '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sft$3.getTypeName()}))).toString());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.x2$1 = x2$1;
                                    }
                                });
                                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                                builder.init(originalDescriptor);
                                attributeDescriptor = originalDescriptor instanceof GeometryDescriptor ? builder.buildDescriptor(definition.name, builder.buildGeometryType()) : builder.buildDescriptor(definition.name, builder.buildType());
                                break block3;
                            }
                            if (!(expression instanceof Function)) break block4;
                            Function function = (Function)expression;
                            Class clazz = function.getFunctionName().getReturn().getType();
                            AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(clazz);
                            attributeDescriptor = Geometry.class.isAssignableFrom(clazz) ? ab.buildDescriptor(definition.name, ab.buildGeometryType()) : ab.buildDescriptor(definition.name, ab.buildType());
                            break block3;
                        }
                        if (!(expression instanceof MathExpressionImpl)) break block5;
                        AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(Double.class);
                        attributeDescriptor = ab.buildDescriptor(definition.name, ab.buildType());
                    }
                    return attributeDescriptor;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't handle transform expression ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{definition.expression})));
            }
            {
                this.sft$3 = sft$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq geomAttributes = (Seq)((TraversableLike)descriptors.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$13) {
                return x$13 instanceof GeometryDescriptor;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$14) {
                return x$14.getLocalName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.setName(sft.getName());
        sftBuilder.addAll((AttributeDescriptor[])descriptors.toArray(ClassTag$.MODULE$.apply(AttributeDescriptor.class)));
        if (geomAttributes.nonEmpty()) {
            String string;
            if (geomAttributes.lengthCompare(1) == 0) {
                string = (String)geomAttributes.head();
            } else {
                String origDefaultGeom = sft.getGeometryDescriptor().getLocalName();
                string = (String)geomAttributes.find((Function1)new Serializable(origDefaultGeom){
                    public static final long serialVersionUID = 0L;
                    private final String origDefaultGeom$1;

                    public final boolean apply(String x$15) {
                        String string = x$15;
                        String string2 = this.origDefaultGeom$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.origDefaultGeom$1 = origDefaultGeom$1;
                    }
                }).getOrElse((Function0)new Serializable(geomAttributes){
                    public static final long serialVersionUID = 0L;
                    private final Seq geomAttributes$1;

                    public final String apply() {
                        return (String)this.geomAttributes$1.head();
                    }
                    {
                        this.geomAttributes$1 = geomAttributes$1;
                    }
                });
            }
            String defaultGeom = string;
            sftBuilder.setDefaultGeometry(defaultGeom);
        }
        return SimpleFeatureTypes$.MODULE$.immutable(sftBuilder.buildFeatureType(), sft.getUserData());
    }

    public final Option org$locationtech$geomesa$index$planning$QueryPlanner$$fromQueryType$1(Query query$3, SimpleFeatureType sft$2) {
        Hints hints = query$3.getHints();
        return QueryHints$.MODULE$.RichHints(hints).isBinQuery() ? new Some(BinAggregatingScan$.MODULE$.propertyNames(hints, sft$2)) : (QueryHints$.MODULE$.RichHints(hints).isDensityQuery() ? new Some(DensityScan$.MODULE$.propertyNames(hints, sft$2)) : (QueryHints$.MODULE$.RichHints(hints).isStatsQuery() ? new Some((Object)StatParser$.MODULE$.propertyNames(sft$2, QueryHints$.MODULE$.RichHints(hints).getStatsQuery(), StatParser$.MODULE$.propertyNames$default$3())) : None$.MODULE$));
    }

    public final Seq org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1(String[] props, Query query$3) {
        String[] names = (String[])Predef$.MODULE$.refArrayOps((Object[])props).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return new StringOps(Predef$.MODULE$.augmentString(p)).contains((Object)BoxesRunTime.boxToCharacter((char)'=')) ? p.substring(0, p.indexOf(61)) : p;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])props).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)query$3.getSortBy())).toSeq().flatMap((Function1)new Serializable(names){
            public static final long serialVersionUID = 0L;
            public final String[] names$1;

            public final ArrayOps<String> apply(SortBy[] sort2) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sort2).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1$1 $outer;

                    public final Iterable<String> apply(SortBy s) {
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)s.getPropertyName()).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1$1$$anonfun$apply$28 $outer;

                            public final Option<String> apply(PropertyName p) {
                                ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$locationtech$geomesa$index$planning$QueryPlanner$$anonfun$$anonfun$$$outer().names$1);
                                return Option$.MODULE$.apply((Object)p.getPropertyName()).filterNot((Function1)new Serializable(this, arrayOps){
                                    public static final long serialVersionUID = 0L;
                                    private final ArrayOps eta$0$2$1;

                                    public final boolean apply(Object elem) {
                                        return this.eta$0$2$1.contains(elem);
                                    }
                                    {
                                        this.eta$0$2$1 = eta$0$2$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }));
                    }

                    public /* synthetic */ anonfun$org$locationtech$geomesa$index$planning$QueryPlanner$$withSort$1$1 org$locationtech$geomesa$index$planning$QueryPlanner$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                this.names$1 = names$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public final boolean org$locationtech$geomesa$index$planning$QueryPlanner$$noop$1(Seq props, SimpleFeatureType sft$2) {
        Seq seq = props;
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft$2.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$10) {
                return x$10.getLocalName();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return !(seq != null ? !seq.equals(object) : object != null);
    }

    private QueryPlanner$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.threadedHints = new SoftThreadLocal();
    }
}

