/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import java.io.IOException;

public class FastByteArrayWrapper {
    protected byte[] buf;
    protected int count;

    public FastByteArrayWrapper() {
        this(32);
    }

    public FastByteArrayWrapper(byte[] buffer) {
        this(buffer, 0);
    }

    public FastByteArrayWrapper(byte[] buffer, int count) {
        if (count < 0 || buffer != null && count > buffer.length) {
            throw new IllegalArgumentException("The specified count is invalid. It can't be lower than zero or greater than the length of the provided buffer");
        }
        this.buf = buffer;
        this.count = count;
    }

    public FastByteArrayWrapper(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

