/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

public class BilinearInterpolator {
    private static final float NULL_NO_DATA = Float.NaN;
    private final float[][] src;
    private float noDataValue = Float.NaN;

    public BilinearInterpolator(float[][] src) {
        this(src, Float.NaN);
    }

    public BilinearInterpolator(float[][] src, float noDataValue) {
        this.src = src;
        this.noDataValue = noDataValue;
    }

    public float[][] interpolate(int width, int height, boolean smoothBoundary) {
        int srcWidth = this.src.length;
        int srcHeight = this.src[0].length;
        float[][] dest = new float[width][height];
        float xRatio = ((float)srcWidth - 1.0f) / (float)width;
        float yRatio = ((float)srcHeight - 1.0f) / (float)height;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float val;
                float x = (float)i * xRatio;
                float y = (float)j * yRatio;
                int ix = (int)x;
                int iy = (int)y;
                float xfrac = x - (float)ix;
                float yfrac = y - (float)iy;
                if (ix < srcWidth - 1 && iy < srcHeight - 1) {
                    float v00 = this.src[ix][iy];
                    float v10 = this.src[ix + 1][iy];
                    float v01 = this.src[ix][iy + 1];
                    float v11 = this.src[ix + 1][iy + 1];
                    val = v00 == this.noDataValue || v10 == this.noDataValue || v01 == this.noDataValue || v11 == this.noDataValue ? (smoothBoundary ? this.interpolateBoundaryCell(xfrac, yfrac, v00, v10, v01, v11) : this.noDataValue) : v00 * (1.0f - xfrac) * (1.0f - yfrac) + v10 * xfrac * (1.0f - yfrac) + v01 * yfrac * (1.0f - xfrac) + v11 * (xfrac * yfrac);
                } else {
                    val = this.src[ix][iy];
                }
                dest[i][j] = val;
            }
        }
        return dest;
    }

    private float interpolateBoundaryCell(float xfrac, float yfrac, float v00, float v10, float v01, float v11) {
        int count = 0;
        if (v00 == this.noDataValue) {
            ++count;
        }
        if (v10 == this.noDataValue) {
            ++count;
        }
        if (v01 == this.noDataValue) {
            ++count;
        }
        if (v11 == this.noDataValue) {
            ++count;
        }
        if (count > 1) {
            return this.noDataValue;
        }
        if (v00 == this.noDataValue) {
            return this.interpolateBoundaryCellNorm(1.0f - yfrac, 1.0f - xfrac, v11, v10, v01);
        }
        if (v11 == this.noDataValue) {
            return this.interpolateBoundaryCellNorm(xfrac, yfrac, v00, v10, v01);
        }
        if (v10 == this.noDataValue) {
            return this.interpolateBoundaryCellNorm(xfrac, 1.0f - yfrac, v01, v11, v00);
        }
        if (v01 == this.noDataValue) {
            return this.interpolateBoundaryCellNorm(1.0f - xfrac, yfrac, v10, v00, v11);
        }
        return this.noDataValue;
    }

    private float interpolateBoundaryCellNorm(float xfrac, float yfrac, float v00, float v10, float v01) {
        if (xfrac + yfrac > 1.0f) {
            return this.noDataValue;
        }
        float dx = v10 - v00;
        float dy = v01 - v00;
        float v = v00 + xfrac * dx + yfrac * dy;
        return v;
    }
}

