/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

@DescribeProcess(title="Query", description="Queries a feature collection using an optional filter and an optional list of attributes to include.  Can also be used to convert feature collection format.")
public class QueryProcess
implements VectorProcess {
    @DescribeResult(name="result", description="The filtered feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="Attribute to include in output", collectionType=String.class, min=0) List<String> attributes, @DescribeParameter(name="filter", min=0, description="The filter to apply") Filter filter) throws ProcessException {
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            features = new FilteringSimpleFeatureCollection(features, filter);
        }
        if (attributes != null && attributes.size() > 0) {
            String[] names = attributes.toArray(new String[attributes.size()]);
            SimpleFeatureType ft = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)features.getSchema(), names);
            if (!ft.equals(features.getSchema())) {
                features = new ReTypingFeatureCollection(features, ft);
            }
        }
        return features;
    }
}

