/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.util.Objects;
import javax.measure.Quantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.spi.Range;

public class QuantityRange<Q extends Quantity<Q>>
extends Range<Quantity<Q>> {
    protected QuantityRange(Quantity<Q> min, Quantity<Q> max, Quantity<Q> resolution) {
        super(min, max, resolution);
    }

    protected QuantityRange(Quantity<Q> min, Quantity<Q> max) {
        super(min, max);
    }

    public static QuantityRange of(Quantity minimum, Quantity maximum, Quantity resolution) {
        return new QuantityRange(minimum, maximum, resolution);
    }

    public static QuantityRange of(Quantity minimum, Quantity maximum) {
        return new QuantityRange(minimum, maximum);
    }

    @Override
    public boolean contains(Quantity<Q> q) {
        if (q != null && q.getValue() != null && q.getUnit() != null && this.hasMinimum() && this.hasMaximum() && q.getUnit().isCompatible(((Quantity)this.getMinimum()).getUnit()) && q.getUnit().isCompatible(((Quantity)this.getMaximum()).getUnit())) {
            if (q instanceof ComparableQuantity) {
                ComparableQuantity cq = (ComparableQuantity)q;
                return cq.isGreaterThanOrEqualTo((Quantity)this.getMinimum()) && cq.isLessThanOrEqualTo((Quantity)this.getMaximum());
            }
            return q.getValue().doubleValue() >= ((Quantity)this.getMinimum()).getValue().doubleValue() && q.getValue().doubleValue() <= ((Quantity)this.getMaximum()).getValue().doubleValue();
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuantityRange) {
            QuantityRange other = (QuantityRange)obj;
            return Objects.equals(this.getMinimum(), other.getMinimum()) && Objects.equals(this.getMaximum(), other.getMaximum()) && Objects.equals(this.getResolution(), other.getResolution());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("min= ").append(this.getMinimum()).append(", max= ").append(this.getMaximum());
        if (this.getResolution() != null) {
            sb.append(", res= ").append(this.getResolution());
        }
        return sb.toString();
    }
}

