/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class DefaultGridFeatureBuilder
extends GridFeatureBuilder {
    public static final String DEFAULT_TYPE_NAME = "grid";
    public static final String ID_ATTRIBUTE_NAME = "id";
    private int id = 0;

    protected static SimpleFeatureType createType(String typeName, CoordinateReferenceSystem crs) {
        String finalName = typeName != null && typeName.trim().length() > 0 ? typeName : DEFAULT_TYPE_NAME;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(finalName);
        tb.add("element", Polygon.class, crs);
        tb.add(ID_ATTRIBUTE_NAME, Integer.class);
        return tb.buildFeatureType();
    }

    public DefaultGridFeatureBuilder() {
        this(DEFAULT_TYPE_NAME, null);
    }

    DefaultGridFeatureBuilder(String typeName) {
        this(typeName, null);
    }

    public DefaultGridFeatureBuilder(CoordinateReferenceSystem crs) {
        this(DEFAULT_TYPE_NAME, crs);
    }

    public DefaultGridFeatureBuilder(String typeName, CoordinateReferenceSystem crs) {
        super(DefaultGridFeatureBuilder.createType(typeName, crs));
    }

    @Override
    public void setAttributes(GridElement el, Map<String, Object> attributes) {
        attributes.put(ID_ATTRIBUTE_NAME, ++this.id);
    }
}

