/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalParam
extends GlobalVariable {
    private boolean implicitlyRequired;

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.implicitlyRequired = requiredParam;
    }

    public boolean isImplicitlyRequiredParam() {
        return this.implicitlyRequired;
    }

    @Override
    public Sequence evaluateVariable(XPathContext context, Component<GlobalVariable> target) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery(this.getPackageData());
        Sequence val = b.getGlobalVariableValue(this);
        if (val != null) {
            return val;
        }
        val = controller.getConvertedParameter(this.getVariableQName(), this.getRequiredType(), context);
        if (val != null) {
            b.setGlobalVariable(this, val);
            return val;
        }
        if (this.isRequiredParam()) {
            XPathException e = new XPathException("No value supplied for required parameter $" + this.getVariableQName().getDisplayName());
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode(this.getPackageData().getHostLanguage() == 50 ? "XTDE0050" : "XPDY0002");
            throw e;
        }
        if (this.isImplicitlyRequiredParam()) {
            XPathException e = new XPathException("A value must be supplied for parameter $" + this.getVariableQName().getDisplayName() + " because there is no default value for the required type");
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode("XTDE0700");
            throw e;
        }
        return this.actuallyEvaluate(context, target);
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        return this.evaluateVariable(context, null);
    }

    @Override
    protected String getFlags() {
        String f = super.getFlags();
        if (this.isImplicitlyRequiredParam()) {
            f = f + "i";
        }
        return f;
    }
}

