/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class MapEntry
extends ExtensionFunctionDefinition {
    public static final StructuredQName FUNCTION_NAME = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "entry");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return FUNCTION_NAME;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                AtomicValue key = (AtomicValue)arguments[0].head();
                assert (key != null);
                GroundedValue value = SequenceExtent.makeSequenceExtent(arguments[1].iterate());
                return HashTrieMap.singleton(key, value, context);
            }
        };
    }
}

