/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private transient QueryModule importingModule;
    private XQueryFunctionLibrary baseLibrary;
    private HashSet<String> namespaces = new HashSet(5);

    public ImportedFunctionLibrary(QueryModule importingModule, XQueryFunctionLibrary baseLibrary) {
        this.importingModule = importingModule;
        this.baseLibrary = baseLibrary;
    }

    public void addImportedNamespace(String namespace) {
        this.namespaces.add(namespace);
    }

    public Expression bind(SymbolicName symbolicName, Expression[] staticArgs, StaticContext env) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        String uri = functionName.getURI();
        RetainedStaticContext rsc = new RetainedStaticContext(env);
        for (Expression arg : staticArgs) {
            if (arg.getRetainedStaticContext() != null) continue;
            arg.setRetainedStaticContext(rsc);
        }
        if (this.namespaces.contains(uri)) {
            Expression call = this.baseLibrary.bind(symbolicName, staticArgs, env);
            if (call != null) {
                XQueryFunction def = this.baseLibrary.getDeclaration(functionName, staticArgs.length);
                this.importingModule.checkImportedFunctionSignature(def);
            }
            return call;
        }
        return null;
    }

    public XQueryFunction getDeclaration(StructuredQName functionName, int staticArgs) {
        String uri = functionName.getURI();
        if (this.namespaces.contains(uri)) {
            return this.baseLibrary.getDeclaration(functionName, staticArgs);
        }
        return null;
    }

    public FunctionLibrary copy() {
        ImportedFunctionLibrary lib = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        for (String ns : this.namespaces) {
            lib.addImportedNamespace(ns);
        }
        return lib;
    }

    public void setImportingModule(QueryModule importingModule) {
        this.importingModule = importingModule;
    }

    public boolean isAvailable(SymbolicName functionName) {
        return this.namespaces.contains(functionName.getComponentName().getURI()) && this.baseLibrary.isAvailable(functionName);
    }
}

