/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;

class ConstructedItemType
extends ItemType {
    private net.sf.saxon.type.ItemType underlyingType;
    private Processor processor;

    protected ConstructedItemType(net.sf.saxon.type.ItemType underlyingType, Processor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        if (underlyingType == null) {
            throw new NullPointerException("underlyingType");
        }
        this.processor = processor;
        this.underlyingType = underlyingType;
    }

    public ConversionRules getConversionRules() {
        return this.processor.getUnderlyingConfiguration().getConversionRules();
    }

    public boolean matches(XdmItem item) throws SaxonApiUncheckedException {
        try {
            TypeHierarchy th = this.processor.getUnderlyingConfiguration().getTypeHierarchy();
            return this.underlyingType.matches((Item)item.getUnderlyingValue(), th);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public boolean subsumes(ItemType other) {
        TypeHierarchy th = this.processor.getUnderlyingConfiguration().getTypeHierarchy();
        return th.isSubType(other.getUnderlyingItemType(), this.underlyingType);
    }

    public net.sf.saxon.type.ItemType getUnderlyingItemType() {
        return this.underlyingType;
    }

    protected Processor getProcessor() {
        return this.processor;
    }
}

