/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;

public class SingletonIterator
implements SequenceIterator,
UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private Item item;
    boolean gone = false;

    private SingletonIterator(Item value) {
        this.item = value;
    }

    public static UnfailingIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.emptyIterator();
        }
        return new SingletonIterator(item);
    }

    public boolean hasNext() {
        return !this.gone;
    }

    public Item next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    public int getLength() {
        return 1;
    }

    public void close() {
    }

    public SingletonIterator getAnother() {
        return new SingletonIterator(this.item);
    }

    public SingletonIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    public GroundedValue materialize() {
        if (this.item instanceof GroundedValue) {
            return (GroundedValue)((Object)this.item);
        }
        return new ZeroOrOne<Item>(this.item);
    }

    public GroundedValue getResidue() throws XPathException {
        return this.gone ? EmptySequence.getInstance() : this.materialize();
    }

    public int getProperties() {
        return 7;
    }
}

