/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.distance;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.AbstractDistanceCalculator;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

public class CartesianDistCalc
extends AbstractDistanceCalculator {
    public static final CartesianDistCalc INSTANCE = new CartesianDistCalc();
    public static final CartesianDistCalc INSTANCE_SQUARED = new CartesianDistCalc(true);
    private final boolean squared;

    public CartesianDistCalc() {
        this.squared = false;
    }

    public CartesianDistCalc(boolean squared) {
        this.squared = squared;
    }

    @Override
    public double distance(Point from, double toX, double toY) {
        double xSquaredPlusYSquared = CartesianDistCalc.distanceSquared(from.getX(), from.getY(), toX, toY);
        if (this.squared) {
            return xSquaredPlusYSquared;
        }
        return Math.sqrt(xSquaredPlusYSquared);
    }

    private static double distanceSquared(double fromX, double fromY, double toX, double toY) {
        double deltaX = fromX - toX;
        double deltaY = fromY - toY;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public double distanceToLineSegment(Point point, double vX, double vY, double wX, double wY) {
        double toY;
        double toX;
        double d = CartesianDistCalc.distanceSquared(vX, vY, wX, wY);
        if (d <= 0.0) {
            toX = vX;
            toY = vY;
        } else {
            double t = ((point.getX() - vX) * (wX - vX) + (point.getY() - vY) * (wY - vY)) / d;
            if (t < 0.0) {
                toX = vX;
                toY = vY;
            } else if (t > 1.0) {
                toX = wX;
                toY = wY;
            } else {
                toX = vX + t * (wX - vX);
                toY = vY + t * (wY - vY);
            }
        }
        return this.distance(point, toX, toY);
    }

    @Override
    public boolean within(Point from, double toX, double toY, double distance) {
        double deltaY;
        double deltaX = from.getX() - toX;
        return deltaX * deltaX + (deltaY = from.getY() - toY) * deltaY <= distance * distance;
    }

    @Override
    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        if (distDEG == 0.0) {
            if (reuse == null) {
                return from;
            }
            reuse.reset(from.getX(), from.getY());
            return reuse;
        }
        double bearingRAD = DistanceUtils.toRadians(bearingDEG);
        double x = from.getX() + Math.sin(bearingRAD) * distDEG;
        double y = from.getY() + Math.cos(bearingRAD) * distDEG;
        if (reuse == null) {
            return ctx.makePoint(x, y);
        }
        reuse.reset(x, y);
        return reuse;
    }

    @Override
    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        double minX = from.getX() - distDEG;
        double maxX = from.getX() + distDEG;
        double minY = from.getY() - distDEG;
        double maxY = from.getY() + distDEG;
        if (reuse == null) {
            return ctx.makeRectangle(minX, maxX, minY, maxY);
        }
        reuse.reset(minX, maxX, minY, maxY);
        return reuse;
    }

    @Override
    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        return from.getY();
    }

    @Override
    public double area(Rectangle rect) {
        return rect.getArea(null);
    }

    @Override
    public double area(Circle circle) {
        return circle.getArea(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianDistCalc that = (CartesianDistCalc)o;
        return this.squared == that.squared;
    }

    public int hashCode() {
        return this.squared ? 1 : 0;
    }
}

