/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.classifier.ColorMapTransformElement;
import it.geosolutions.jaiext.classifier.ColorMapUtilities;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.math.BigInteger;
import java.util.AbstractList;

public final class LinearColorMap
extends AbstractList<LinearColorMapElement>
implements ColorMapTransform<LinearColorMapElement> {
    private IndexColorModel colorModel;
    private final LinearColorMapElement[] standardElements;
    private final LinearColorMapElement[] preFilteringElements;
    private final Color defaultColor;
    private DefaultPiecewiseTransform1D<LinearColorMapElement> piecewise;
    private DefaultPiecewiseTransform1D<LinearColorMapElement> preFilteringPiecewise;
    private Color preFilteringColor;
    private String name;
    private int hashCode = -1;

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements) {
        this(name, standardElements, null);
    }

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements, Color defColor) {
        this(name, standardElements, null, defColor);
    }

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements, LinearColorMapElement[] preFilteringElements, Color defaultColor) {
        ColorMapUtilities.ensureNonNull("name", name);
        ColorMapUtilities.ensureNonNull("standardElements", standardElements);
        this.name = name + "";
        LinearColorMap.preliminarChecks(standardElements, preFilteringElements);
        if (preFilteringElements != null && preFilteringElements.length > 0) {
            Color color;
            this.preFilteringElements = (LinearColorMapElement[])preFilteringElements.clone();
            this.preFilteringColor = color = this.preFilteringElements[0].getColors()[0];
        } else {
            this.preFilteringElements = null;
        }
        this.standardElements = (LinearColorMapElement[])standardElements.clone();
        this.defaultColor = defaultColor;
    }

    public LinearColorMap(String string, LinearColorMapElement[] linearColorMapElements, LinearColorMapElement[] linearColorMapElements2) {
        this(string, linearColorMapElements, linearColorMapElements2, null);
    }

    private static void preliminarChecks(LinearColorMapElement[] domainElements, LinearColorMapElement[] domainElementsToPreserve) {
        ColorMapUtilities.checkPreservingElements(domainElementsToPreserve);
        int num = domainElementsToPreserve != null ? domainElements.length + domainElementsToPreserve.length : domainElements.length;
        for (int i = 0; i < num; ++i) {
            LinearColorMapElement c0 = i >= domainElements.length ? domainElementsToPreserve[i - domainElements.length] : domainElements[i];
            ColorMapTransformElement v0 = c0;
            Range outRange0 = c0.getOutputRange();
            Color[] colors0 = v0.getColors();
            int minimum0 = outRange0.getMin().intValue();
            int maximum0 = outRange0.getMax().intValue();
            for (int j = 0; j < num; ++j) {
                if (j == i) continue;
                LinearColorMapElement c1 = j >= domainElements.length ? domainElementsToPreserve[j - domainElements.length] : domainElements[j];
                ColorMapTransformElement v1 = c1;
                Range outRange1 = c1.getOutputRange();
                if (!outRange1.intersects(outRange0) || !outRange0.intersects(outRange1)) continue;
                int minimum1 = outRange1.getMin().intValue();
                int maximum1 = outRange1.getMax().intValue();
                Color[] colors1 = v1.getColors();
                if (minimum1 == maximum0 && colors0[colors0.length - 1].equals(colors1[0]) || minimum0 == maximum1 && colors1[colors1.length - 1].equals(colors0[0])) continue;
                throw new IllegalArgumentException("Wrong values defined");
            }
        }
    }

    @Override
    public IndexColorModel getColorModel() {
        this.initColorModel();
        return this.colorModel;
    }

    private synchronized void initColorModel() {
        if (this.colorModel == null) {
            boolean defaultColorFound;
            BigInteger bits = new BigInteger("0");
            boolean preFilteringValuesPresent = this.preFilteringColor != null;
            int elementsCount = this.standardElements.length + (preFilteringValuesPresent ? 1 : 0);
            int max = -1;
            for (int i = 0; i < elementsCount; ++i) {
                LinearColorMapElement element = i < this.standardElements.length ? this.standardElements[i] : this.preFilteringElements[0];
                int elementMin = (int)element.getOutputMinimum();
                int elementMax = (int)element.getOutputMaximum();
                for (int k = elementMin; k <= elementMax; ++k) {
                    bits = bits.setBit(k);
                }
                max = Math.max(max, elementMax);
            }
            int[] ARGB = new int[++max];
            int outMax = 0;
            int outMin = 0;
            for (int i = 0; i < elementsCount; ++i) {
                LinearColorMapElement element = i < this.standardElements.length ? this.standardElements[i] : this.preFilteringElements[0];
                outMin = (int)element.getOutputMinimum();
                outMax = (int)element.getOutputMaximum();
                ColorMapUtilities.expand(element.getColors(), ARGB, outMin, outMax + 1);
            }
            this.preFilteringPiecewise = this.preFilteringElements == null ? null : new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.preFilteringElements);
            boolean lookForDefaultColor = this.defaultColor != null;
            boolean bl = defaultColorFound = !lookForDefaultColor;
            if (lookForDefaultColor) {
                int i;
                int defaultColorIndex = -1;
                for (i = 0; i < ARGB.length; ++i) {
                    if (!lookForDefaultColor || defaultColorIndex != -1 || !bits.testBit(i) || ARGB[i] != this.defaultColor.getRGB()) continue;
                    defaultColorIndex = i;
                    defaultColorFound = true;
                    break;
                }
                if (defaultColorFound) {
                    this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements, (double)defaultColorIndex);
                } else {
                    for (i = 0; i < max && bits.testBit(i); ++i) {
                    }
                    if (i == max) {
                        max = i == max ? max + 1 : max;
                        bits = bits.setBit(i);
                        int[] tempARGB = new int[max];
                        System.arraycopy(ARGB, 0, tempARGB, 0, ARGB.length);
                        tempARGB[tempARGB.length - 1] = this.defaultColor.getRGB();
                        ARGB = tempARGB;
                    }
                    this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements, (double)(max - 1));
                }
            } else {
                this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements);
            }
            this.colorModel = new IndexColorModel(ColorMapUtilities.getBitCount(max), max, ARGB, 0, ColorMapUtilities.getTransferType(max), bits);
        }
    }

    @Override
    public SampleModel getSampleModel(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("Width cannot be < 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Height cannot be < 0");
        }
        this.initColorModel();
        return new PixelInterleavedSampleModel(this.colorModel.getTransferType(), width, height, 1, width, new int[1]);
    }

    @Override
    public LinearColorMapElement get(int index) {
        if (index < this.standardElements.length) {
            return this.standardElements[index];
        }
        if (this.preFilteringElements != null) {
            return this.preFilteringElements[index - this.standardElements.length];
        }
        throw new ArrayIndexOutOfBoundsException("Colormap Index is outside the colormap bounds");
    }

    @Override
    public int size() {
        int size = this.preFilteringElements != null ? this.preFilteringElements.length : 0;
        return size += this.standardElements.length;
    }

    public double getDefaultValue() {
        this.initColorModel();
        return this.piecewise.getDefaultValue();
    }

    public boolean hasDefaultValue() {
        this.initColorModel();
        return this.piecewise.hasDefaultValue();
    }

    public Range getApproximateDomainRange() {
        this.initColorModel();
        return this.piecewise.getApproximateDomainRange();
    }

    public LinearColorMapElement findDomainElement(double sample) {
        this.initColorModel();
        boolean prefiltering = this.preFilteringElements != null;
        LinearColorMapElement retValue = null;
        if (prefiltering) {
            retValue = (LinearColorMapElement)this.preFilteringPiecewise.findDomainElement(sample);
        }
        if (retValue == null) {
            retValue = (LinearColorMapElement)this.piecewise.findDomainElement(sample);
        }
        return retValue;
    }

    public LinearColorMapElement[] getDomainElements() {
        return (LinearColorMapElement[])this.standardElements.clone();
    }

    public String getName() {
        this.initColorModel();
        return this.name;
    }

    public boolean hasGaps() {
        this.initColorModel();
        return this.piecewise.hasGaps();
    }

    public double transform(double value) throws TransformationException {
        this.initColorModel();
        LinearColorMapElement transform = this.findDomainElement(value);
        if (transform != null) {
            return transform.transform(value);
        }
        return this.preFilteringPiecewise.transform(value);
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        ColorMapUtilities.ensureNonNull("ptSrc", ptSrc);
        if (ptDst == null) {
            ptDst = new Position();
        }
        ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
        return ptDst;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinearColorMap)) {
            return false;
        }
        LinearColorMap that = (LinearColorMap)o;
        if (!PiecewiseUtilities.equals((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!PiecewiseUtilities.equals((Object)this.defaultColor, (Object)that.defaultColor)) {
            return false;
        }
        if (this.preFilteringColor != that.preFilteringColor) {
            return false;
        }
        if (!PiecewiseUtilities.equals((Object)this.preFilteringElements, (Object)that.preFilteringElements)) {
            return false;
        }
        if (!PiecewiseUtilities.equals((Object)this.standardElements, (Object)that.standardElements)) {
            return false;
        }
        return this.piecewise.equals(that.piecewise);
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash((Object)this.name, (int)this.hashCode);
        this.hashCode = PiecewiseUtilities.hash((Object)this.defaultColor, (int)this.hashCode);
        this.hashCode = PiecewiseUtilities.hash((Object)this.preFilteringColor, (int)this.hashCode);
        this.hashCode = PiecewiseUtilities.hash((Object)this.preFilteringElements, (int)this.hashCode);
        this.hashCode = PiecewiseUtilities.hash((Object)this.standardElements, (int)this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.piecewise, (int)this.hashCode);
        return this.hashCode;
    }

    public static final class LinearColorMapType {
        public static final int TYPE_RAMP = 1;
        public static final int TYPE_VALUES = 3;
        public static final int TYPE_INTERVALS = 2;

        public static boolean validateColorMapTye(int linearColorMapType) {
            switch (linearColorMapType) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
    }
}

