/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.metadata.PropertyMap;
import org.geotools.metadata.PropertyTree;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.metadata.i18n.Errors;

public final class MetadataStandard {
    public static final MetadataStandard ISO_19111 = new MetadataStandard("org.opengis.referencing.");
    public static final MetadataStandard ISO_19115 = new MetadataStandard("org.opengis.metadata.");
    public static final MetadataStandard ISO_19119 = new MetadataStandard("org.opengis.service.");
    private final String interfacePackage;
    private final Map<Class<?>, PropertyAccessor> accessors = new HashMap();
    private final ThreadLocal<PropertyTree> treeBuilders = new ThreadLocal<PropertyTree>(){

        @Override
        protected PropertyTree initialValue() {
            return new PropertyTree(MetadataStandard.this);
        }
    };

    public MetadataStandard(String interfacePackage) {
        if (!interfacePackage.endsWith(".")) {
            interfacePackage = interfacePackage + '.';
        }
        this.interfacePackage = interfacePackage;
    }

    private PropertyAccessor getAccessor(Class<?> implementation) throws ClassCastException {
        PropertyAccessor accessor = this.getAccessorOptional(implementation);
        if (accessor == null) {
            throw new ClassCastException(Errors.format(187, implementation.getName()));
        }
        return accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PropertyAccessor getAccessorOptional(Class<?> implementation) {
        Map<Class<?>, PropertyAccessor> map = this.accessors;
        synchronized (map) {
            Class<?> type;
            PropertyAccessor accessor = this.accessors.get(implementation);
            if (accessor == null && (type = this.getType(implementation)) != null) {
                accessor = new PropertyAccessor(implementation, type);
                this.accessors.put(implementation, accessor);
            }
            return accessor;
        }
    }

    private Class<?> getType(Class<?> implementation) {
        return PropertyAccessor.getType(implementation, this.interfacePackage);
    }

    public Class<?> getInterface(Class<?> implementation) throws ClassCastException {
        return this.getAccessor(implementation).type;
    }

    public Map<String, Object> asMap(Object metadata) throws ClassCastException {
        return new PropertyMap(metadata, this.getAccessor(metadata.getClass()));
    }

    public TreeModel asTree(Object metadata) throws ClassCastException {
        PropertyTree builder = this.treeBuilders.get();
        return new DefaultTreeModel(builder.asTree(metadata), true);
    }

    final boolean isModifiable(Class implementation) throws ClassCastException {
        return this.getAccessor(implementation).isModifiable();
    }

    final void freeze(Object metadata) throws ClassCastException {
        this.getAccessor(metadata.getClass()).freeze(metadata);
    }

    public void shallowCopy(Object source, Object target, boolean skipNulls) throws ClassCastException, UnmodifiableMetadataException {
        MetadataStandard.ensureNonNull("target", target);
        PropertyAccessor accessor = this.getAccessor(target.getClass());
        if (!accessor.type.isInstance(source)) {
            MetadataStandard.ensureNonNull("source", source);
            throw new ClassCastException(Errors.format(61, source.getClass(), accessor.type));
        }
        if (!accessor.shallowCopy(source, target, skipNulls)) {
            throw new UnmodifiableMetadataException(Errors.format(190));
        }
    }

    public boolean shallowEquals(Object metadata1, Object metadata2, boolean skipNulls) throws ClassCastException {
        if (metadata1 == metadata2) {
            return true;
        }
        if (metadata1 == null || metadata2 == null) {
            return false;
        }
        PropertyAccessor accessor = this.getAccessor(metadata1.getClass());
        if (!accessor.type.equals(this.getType(metadata2.getClass()))) {
            return false;
        }
        return accessor.shallowEquals(metadata1, metadata2, skipNulls);
    }

    public int hashCode(Object metadata) throws ClassCastException {
        return this.getAccessor(metadata.getClass()).hashCode(metadata);
    }

    public String toString(Object metadata) throws ClassCastException {
        PropertyTree builder = this.treeBuilders.get();
        return PropertyTree.toString(builder.asTree(metadata));
    }

    private static void ensureNonNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException(Errors.format(143, name));
        }
    }
}

