/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.math;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.geotools.metadata.i18n.Descriptions;
import org.geotools.util.TableWriter;
import org.opengis.util.Cloneable;

public class Statistics
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -22884277805533726L;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double sum = 0.0;
    private double sum2 = 0.0;
    private int n = 0;
    private int nNaN = 0;

    public void reset() {
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.sum = 0.0;
        this.sum2 = 0.0;
        this.n = 0;
        this.nNaN = 0;
    }

    public void add(double sample) {
        if (!Double.isNaN(sample)) {
            if (!(this.min <= sample)) {
                this.min = sample;
            }
            if (!(this.max >= sample)) {
                this.max = sample;
            }
            this.sum2 += sample * sample;
            this.sum += sample;
            ++this.n;
        } else {
            ++this.nNaN;
        }
    }

    public void add(long sample) {
        double fdatum = sample;
        if (!(this.min <= fdatum)) {
            this.min = fdatum;
        }
        if (!(this.max >= fdatum)) {
            this.max = fdatum;
        }
        this.sum2 += fdatum * fdatum;
        this.sum += fdatum;
        ++this.n;
    }

    public void add(Statistics stats) {
        if (stats != null) {
            if (Double.isNaN(this.min) || stats.min < this.min) {
                this.min = stats.min;
            }
            if (Double.isNaN(this.max) || stats.max > this.max) {
                this.max = stats.max;
            }
            this.sum2 += stats.sum2;
            this.sum += stats.sum;
            this.n += stats.n;
            this.nNaN += stats.nNaN;
        }
    }

    public int countNaN() {
        return Math.max(this.nNaN, 0);
    }

    public int count() {
        return this.n;
    }

    public double minimum() {
        return this.min;
    }

    public double maximum() {
        return this.max;
    }

    public double range() {
        return this.max - this.min;
    }

    public double mean() {
        return this.sum / (double)this.n;
    }

    public double rms() {
        return Math.sqrt(this.sum2 / (double)this.n);
    }

    public double standardDeviation(boolean allPopulation) {
        return Math.sqrt((this.sum2 - this.sum * this.sum / (double)this.n) / (double)(allPopulation ? this.n : this.n - 1));
    }

    @Override
    public Statistics clone() {
        try {
            return (Statistics)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            Statistics cast = (Statistics)obj;
            return this.n == cast.n && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(cast.min) && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(cast.max) && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(cast.sum) && Double.doubleToLongBits(this.sum2) == Double.doubleToLongBits(cast.sum2);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.min) + 37L * (Double.doubleToLongBits(this.max) + 37L * (Double.doubleToLongBits(this.sum) + 37L * Double.doubleToLongBits(this.sum2)));
        return (int)code ^ (int)(code >>> 32) ^ this.n;
    }

    public final String toString() {
        return this.toString(null, false);
    }

    public String toString(Locale locale, boolean tabulations) {
        String text = Descriptions.getResources(locale).getString(3, new Number[]{this.count(), this.minimum(), this.maximum(), this.mean(), this.rms(), this.standardDeviation(false)});
        if (!tabulations) {
            try (TableWriter tmp = new TableWriter(null, 1);){
                tmp.write(text);
                tmp.setColumnAlignment(1, 2);
                text = tmp.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return text;
    }

    public static class Delta
    extends Statistics {
        private static final long serialVersionUID = 3464306833883333219L;
        private Statistics delta;
        private double last = Double.NaN;
        private long lastAsLong;

        public Delta() {
            this.delta = new Statistics();
            this.delta.nNaN = -1;
        }

        public Delta(Statistics delta) {
            this.delta = delta;
            delta.reset();
            delta.nNaN = -1;
        }

        public Statistics getDeltaStatistics() {
            return this.delta;
        }

        @Override
        public void reset() {
            super.reset();
            this.delta.reset();
            this.delta.nNaN = -1;
            this.last = Double.NaN;
            this.lastAsLong = 0L;
        }

        @Override
        public void add(double sample) {
            super.add(sample);
            this.delta.add(sample - this.last);
            this.last = sample;
            this.lastAsLong = (long)sample;
        }

        @Override
        public void add(long sample) {
            super.add(sample);
            if (this.last == (double)this.lastAsLong) {
                this.delta.add(sample - this.lastAsLong);
            } else {
                this.delta.add((double)sample - this.last);
            }
            this.last = sample;
            this.lastAsLong = sample;
        }

        @Override
        public void add(Statistics stats) throws ClassCastException {
            if (stats != null) {
                Delta toAdd = (Delta)stats;
                if (toAdd.delta.nNaN >= 0) {
                    this.delta.add(toAdd.delta);
                    this.last = toAdd.last;
                    this.lastAsLong = toAdd.lastAsLong;
                    super.add(stats);
                }
            }
        }

        @Override
        public Delta clone() {
            Delta copy = (Delta)super.clone();
            copy.delta = copy.delta.clone();
            return copy;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.delta.equals(((Delta)obj).delta);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 37 * this.delta.hashCode();
        }
    }
}

