/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="If exception, presume unaligned")
public final class UnsafeAccess {
    private static final Log LOG = LogFactory.getLog(UnsafeAccess.class);
    public static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(null);
            }
            catch (Throwable e) {
                LOG.warn((Object)"sun.misc.Unsafe is not accessible", e);
                return null;
            }
        }
    });
    public static final int BYTE_ARRAY_BASE_OFFSET = theUnsafe != null ? theUnsafe.arrayBaseOffset(byte[].class) : -1;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeAccess() {
    }

    public static void copy(byte[] src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress = destOffset;
        byte[] destBase = null;
        if (dest.isDirect()) {
            destAddress += ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = destAddress + (long)BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        long srcAddress = srcOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(src, srcAddress, destBase, destAddress, length);
    }

    private static void unsafeCopy(Object src, long srcAddr, Object dst, long destAddr, long len) {
        while (len > 0L) {
            long size = len > 0x100000L ? 0x100000L : len;
            theUnsafe.copyMemory(src, srcAddr, dst, destAddr, len);
            len -= size;
            srcAddr += size;
            destAddr += size;
        }
    }

    public static void copy(ByteBuffer src, int srcOffset, byte[] dest, int destOffset, int length) {
        long srcAddress = srcOffset;
        byte[] srcBase = null;
        if (src.isDirect()) {
            srcAddress += ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = srcAddress + (long)BYTE_ARRAY_BASE_OFFSET + (long)src.arrayOffset();
            srcBase = src.array();
        }
        long destAddress = destOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, dest, destAddress, length);
    }

    public static void copy(ByteBuffer src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress;
        long srcAddress;
        byte[] srcBase = null;
        byte[] destBase = null;
        if (src.isDirect()) {
            srcAddress = (long)srcOffset + ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = srcOffset + src.arrayOffset() + BYTE_ARRAY_BASE_OFFSET;
            srcBase = src.array();
        }
        if (dest.isDirect()) {
            destAddress = (long)destOffset + ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = destOffset + BYTE_ARRAY_BASE_OFFSET + dest.arrayOffset();
            destBase = dest.array();
        }
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, destBase, destAddress, length);
    }
}

