/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015baB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0013\u0011\n\u000b7/Z#ya>\u0014HoQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011!\u00025cCN,'BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019qC\u0007\u000f\u000e\u0003aQ!aA\r\u000b\u0005\u0015A\u0011BA\u000e\u0019\u00055)\u0005\u0010]8si\u000e{W.\\1oIB\u0011Q\u0004I\u0007\u0002=)\u0011qDB\u0001\u0005I\u0006$\u0018-\u0003\u0002\"=\tq\u0001JQ1tK\u0012\u000bG/Y*u_J,\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u0013j]&$H\u0005F\u0001&!\t\tb%\u0003\u0002(%\t!QK\\5u\u0011\u001dI\u0003A1A\u0005B)\na\u0001]1sC6\u001cX#A\u0016\u0011\u00051*eBA\u0017=\u001d\tq3H\u0004\u00020u9\u0011\u0001'\u000f\b\u0003car!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bu\u0012\u0001\u0012\u0001 \u0002%!\u0013\u0015m]3FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003\u007f\u0001k\u0011A\u0001\u0004\u0006\u0003\tA\t!Q\n\u0003\u0001BAQa\u0011!\u0005\u0002\u0011\u000ba\u0001P5oSRtD#\u0001 \u0007\t\u0019\u0003\u0005a\u0012\u0002\u0012\u0011\n\u000b7/Z#ya>\u0014H\u000fU1sC6\u001c8cB#\u0011\u0011NSf,\u0019\t\u0003\u0013Bs!A\u0013(\u000f\u0005-keB\u0001\u0019M\u0013\t)\u0001\"\u0003\u0002\u00043%\u0011q\nG\u0001\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\n\u0005E\u0013&\u0001D#ya>\u0014H\u000fU1sC6\u001c(BA(\u0019!\t!vK\u0004\u0002/+&\u0011a\u000bB\u0001\u0016\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0013\tA\u0016LA\u0006I\u0005\u0006\u001cX\rU1sC6\u001c(B\u0001,\u0005!\tYF,D\u0001\u001a\u0013\ti\u0016DA\u000bSKF,\u0018N]3e)f\u0004XMT1nKB\u000b'/Y7\u0011\u0005m{\u0016B\u00011\u001a\u0005Iy\u0005\u000f^5p]\u0006d\u0017J\u001c3fqB\u000b'/Y7\u0011\u0005Q\u0013\u0017BA2Z\u0005]!vnZ4mKJ+Wn\u001c;f\r&dG/\u001a:QCJ\fW\u000eC\u0003D\u000b\u0012\u0005Q\rF\u0001g!\t9W)D\u0001AQ\u0011)\u0015n\u001d;\u0011\u0005)\fX\"A6\u000b\u00051l\u0017A\u00036d_6l\u0017M\u001c3fe*\u0011an\\\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002a\u0006\u00191m\\7\n\u0005I\\'A\u0003)be\u0006lW\r^3sg\u0006\u00112m\\7nC:$G)Z:de&\u0004H/[8oC\u0005)\u0018!K#ya>\u0014H\u000f\t4fCR,(/Z:!MJ|W\u000eI1!\u000f\u0016|W*Z:bA\u0011\fG/\u0019\u0011ti>\u0014X\r\u0003\u0004x\u0001\u0001\u0006IaK\u0001\ba\u0006\u0014\u0018-\\:!\u0011\u0015I\b\u0001\"\u0015{\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u0004&w\u0006=\u00111\u0003\u0005\u0006yb\u0004\r!`\u0001\u0004U>\u0014\u0007c\u0001@\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!C7baJ,G-^2f\u0015\u0011\t)!a\u0002\u0002\r!\fGm\\8q\u0015\r\tI\u0001D\u0001\u0007CB\f7\r[3\n\u0007\u00055qPA\u0002K_\nDa!!\u0005y\u0001\u0004a\u0012A\u00013t\u0011\u001d\t)\u0002\u001fa\u0001\u0003/\tQ!];fef\u0004B!!\u0007\u0002\"5\u0011\u00111\u0004\u0006\u0004?\u0005u!bAA\u0010\u0019\u0005Aq-Z8u_>d7/\u0003\u0003\u0002$\u0005m!!B)vKJL\b")
public interface HBaseExportCommand
extends ExportCommand<HBaseDataStore> {
    public void org$locationtech$geomesa$hbase$tools$export$HBaseExportCommand$_setter_$params_$eq(HBaseExportParams var1);

    public HBaseExportParams params();

    public void configure(Job var1, HBaseDataStore var2, Query var3);

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class HBaseExportParams
    implements ExportCommand.ExportParams,
    HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    OptionalIndexParam,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed export)", validateWith=PositiveInteger.class)
        private Integer reducers;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public HBaseExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

