/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ValueQueue<E> {
    private static final String REFILL_THREAD = ValueQueue.class.getName() + "_thread";
    private final LoadingCache<String, LinkedBlockingQueue<E>> keyQueues;
    private final ThreadPoolExecutor executor;
    private final UniqueKeyBlockingQueue queue = new UniqueKeyBlockingQueue();
    private final QueueRefiller<E> refiller;
    private final SyncGenerationPolicy policy;
    private final int numValues;
    private final float lowWatermark;
    private volatile boolean executorThreadsStarted = false;

    public ValueQueue(final int numValues, final float lowWatermark, long expiry, int numFillerThreads, SyncGenerationPolicy policy, final QueueRefiller<E> refiller) {
        Preconditions.checkArgument((numValues > 0 ? 1 : 0) != 0, (Object)"\"numValues\" must be > 0");
        Preconditions.checkArgument((lowWatermark > 0.0f && lowWatermark <= 1.0f ? 1 : 0) != 0, (Object)"\"lowWatermark\" must be > 0 and <= 1");
        Preconditions.checkArgument((expiry > 0L ? 1 : 0) != 0, (Object)"\"expiry\" must be > 0");
        Preconditions.checkArgument((numFillerThreads > 0 ? 1 : 0) != 0, (Object)"\"numFillerThreads\" must be > 0");
        Preconditions.checkNotNull((Object)((Object)policy), (Object)"\"policy\" must not be null");
        this.refiller = refiller;
        this.policy = policy;
        this.numValues = numValues;
        this.lowWatermark = lowWatermark;
        this.keyQueues = CacheBuilder.newBuilder().expireAfterAccess(expiry, TimeUnit.MILLISECONDS).build(new CacheLoader<String, LinkedBlockingQueue<E>>(){

            public LinkedBlockingQueue<E> load(String keyName) throws Exception {
                LinkedBlockingQueue keyQueue = new LinkedBlockingQueue();
                refiller.fillQueueForKey(keyName, keyQueue, (int)(lowWatermark * (float)numValues));
                return keyQueue;
            }
        });
        this.executor = new ThreadPoolExecutor(numFillerThreads, numFillerThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.queue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(REFILL_THREAD).build());
    }

    public ValueQueue(int numValues, float lowWaterMark, long expiry, int numFillerThreads, QueueRefiller<E> fetcher) {
        this(numValues, lowWaterMark, expiry, numFillerThreads, SyncGenerationPolicy.ALL, fetcher);
    }

    public void initializeQueuesForKeys(String ... keyNames) throws ExecutionException {
        for (String keyName : keyNames) {
            this.keyQueues.get((Object)keyName);
        }
    }

    public E getNext(String keyName) throws IOException, ExecutionException {
        return this.getAtMost(keyName, 1).get(0);
    }

    public void drain(String keyName) {
        try {
            ((LinkedBlockingQueue)this.keyQueues.get((Object)keyName)).clear();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public List<E> getAtMost(String keyName, int num) throws IOException, ExecutionException {
        LinkedBlockingQueue keyQueue = (LinkedBlockingQueue)this.keyQueues.get((Object)keyName);
        LinkedList ekvs = new LinkedList();
        try {
            for (int i = 0; i < num; ++i) {
                Object val = keyQueue.poll();
                if (val == null) {
                    int numToFill = 0;
                    switch (this.policy) {
                        case ATLEAST_ONE: {
                            numToFill = ekvs.size() < 1 ? 1 : 0;
                            break;
                        }
                        case LOW_WATERMARK: {
                            numToFill = Math.min(num, (int)(this.lowWatermark * (float)this.numValues)) - ekvs.size();
                            break;
                        }
                        case ALL: {
                            numToFill = num - ekvs.size();
                        }
                    }
                    if (numToFill > 0) {
                        this.refiller.fillQueueForKey(keyName, ekvs, numToFill);
                    }
                    if (i <= (int)(this.lowWatermark * (float)this.numValues)) {
                        this.submitRefillTask(keyName, keyQueue);
                    }
                    return ekvs;
                }
                ekvs.add(val);
            }
        }
        catch (Exception e) {
            throw new IOException("Exeption while contacting value generator ", e);
        }
        return ekvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRefillTask(String keyName, final Queue<E> keyQueue) throws InterruptedException {
        if (!this.executorThreadsStarted) {
            ValueQueue valueQueue = this;
            synchronized (valueQueue) {
                this.executor.prestartAllCoreThreads();
                this.executorThreadsStarted = true;
            }
        }
        this.queue.put(new NamedRunnable(keyName){

            @Override
            public void run() {
                int cacheSize = ValueQueue.this.numValues;
                int threshold = (int)(ValueQueue.this.lowWatermark * (float)cacheSize);
                try {
                    if (keyQueue.size() < threshold) {
                        ValueQueue.this.refiller.fillQueueForKey(this.name, keyQueue, cacheSize - keyQueue.size());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    public static enum SyncGenerationPolicy {
        ATLEAST_ONE,
        LOW_WATERMARK,
        ALL;

    }

    private static class UniqueKeyBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = -2152747693695890371L;
        private HashSet<String> keysInProgress = new HashSet();

        private UniqueKeyBlockingQueue() {
        }

        @Override
        public synchronized void put(Runnable e) throws InterruptedException {
            if (this.keysInProgress.add(((NamedRunnable)e).name)) {
                super.put(e);
            }
        }

        @Override
        public Runnable take() throws InterruptedException {
            Runnable k = (Runnable)super.take();
            if (k != null) {
                this.keysInProgress.remove(((NamedRunnable)k).name);
            }
            return k;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable k = (Runnable)super.poll(timeout, unit);
            if (k != null) {
                this.keysInProgress.remove(((NamedRunnable)k).name);
            }
            return k;
        }
    }

    private static abstract class NamedRunnable
    implements Runnable {
        final String name;

        private NamedRunnable(String keyName) {
            this.name = keyName;
        }
    }

    public static interface QueueRefiller<E> {
        public void fillQueueForKey(String var1, Queue<E> var2, int var3) throws IOException;
    }
}

