/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;

public class HardLink {
    private static HardLinkCommandGetter getHardLinkCommand;
    public final LinkStats linkStats = new LinkStats();

    protected static int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
        return getHardLinkCommand.getLinkMultArgLength(fileDir, fileBaseNames, linkDir);
    }

    protected static int getMaxAllowedCmdArgLength() {
        return getHardLinkCommand.getMaxAllowedCmdArgLength();
    }

    public static void createHardLink(File file, File linkName) throws IOException {
        if (file == null) {
            throw new IOException("invalid arguments to createHardLink: source file is null");
        }
        if (linkName == null) {
            throw new IOException("invalid arguments to createHardLink: link name is null");
        }
        Object[] hardLinkCommand = getHardLinkCommand.linkOne(file, linkName);
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor((String[])hardLinkCommand);
        try {
            shexec.execute();
        }
        catch (Shell.ExitCodeException e) {
            throw new IOException("Failed to execute command " + Arrays.toString(hardLinkCommand) + "; command output: \"" + shexec.getOutput() + "\"" + "; WrappedException: \"" + e.getMessage() + "\"");
        }
    }

    public static void createHardLinkMult(File parentDir, String[] fileBaseNames, File linkDir) throws IOException {
        HardLink.createHardLinkMult(parentDir, fileBaseNames, linkDir, getHardLinkCommand.getMaxAllowedCmdArgLength());
    }

    protected static int createHardLinkMult(File parentDir, String[] fileBaseNames, File linkDir, int maxLength) throws IOException {
        if (parentDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: parent directory is null");
        }
        if (linkDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: link directory is null");
        }
        if (fileBaseNames == null) {
            throw new IOException("invalid arguments to createHardLinkMult: filename list can be empty but not null");
        }
        if (fileBaseNames.length == 0) {
            return 0;
        }
        if (!linkDir.exists()) {
            throw new FileNotFoundException(linkDir + " not found.");
        }
        int callCount = 0;
        if (HardLink.getLinkMultArgLength(parentDir, fileBaseNames, linkDir) > maxLength && fileBaseNames.length > 1) {
            String[] list1 = Arrays.copyOf(fileBaseNames, fileBaseNames.length / 2);
            callCount += HardLink.createHardLinkMult(parentDir, list1, linkDir, maxLength);
            String[] list2 = Arrays.copyOfRange(fileBaseNames, fileBaseNames.length / 2, fileBaseNames.length);
            return callCount += HardLink.createHardLinkMult(parentDir, list2, linkDir, maxLength);
        }
        callCount = 1;
        String[] hardLinkCommand = getHardLinkCommand.linkMult(fileBaseNames, linkDir);
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(hardLinkCommand, parentDir, null, 0L);
        try {
            shexec.execute();
        }
        catch (Shell.ExitCodeException e) {
            throw new IOException(shexec.getOutput() + e.getMessage());
        }
        return callCount;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLinkCount(File fileName) throws IOException {
        int result222222;
        Shell.ShellCommandExecutor shexec;
        BufferedReader in;
        int exitValue;
        String errMsg;
        String inpMsg;
        block9: {
            if (fileName == null) {
                throw new IOException("invalid argument to getLinkCount: file name is null");
            }
            if (!fileName.exists()) {
                throw new FileNotFoundException(fileName + " not found.");
            }
            String[] cmd = getHardLinkCommand.linkCount(fileName);
            inpMsg = null;
            errMsg = null;
            exitValue = -1;
            in = null;
            shexec = new Shell.ShellCommandExecutor(cmd);
            shexec.execute();
            in = new BufferedReader(new StringReader(shexec.getOutput()));
            inpMsg = in.readLine();
            exitValue = shexec.getExitCode();
            if (inpMsg == null || exitValue != 0) {
                throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, null);
            }
            if (!Shell.SOLARIS) break block9;
            String[] result222222 = inpMsg.split("\\s+");
            int n = Integer.parseInt(result222222[1]);
            IOUtils.closeStream(in);
            return n;
        }
        try {
            result222222 = Integer.parseInt(inpMsg);
        }
        catch (Shell.ExitCodeException e) {
            try {
                inpMsg = shexec.getOutput();
                errMsg = e.getMessage();
                exitValue = e.getExitCode();
                throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e);
                catch (NumberFormatException e2) {
                    throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
        }
        IOUtils.closeStream(in);
        return result222222;
    }

    private static IOException createIOException(File f, String message, String error, int exitvalue, Exception cause) {
        String s = "Failed to get link count on file " + f + ": message=" + message + "; error=" + error + "; exit value=" + exitvalue;
        return cause == null ? new IOException(s) : new IOException(s, cause);
    }

    static {
        if (Shell.WINDOWS) {
            getHardLinkCommand = new HardLinkCGWin();
        } else {
            getHardLinkCommand = new HardLinkCGUnix();
            if (Shell.MAC || Shell.FREEBSD) {
                String[] linkCountCmdTemplate = new String[]{"/usr/bin/stat", "-f%l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            } else if (Shell.SOLARIS) {
                String[] linkCountCmdTemplate = new String[]{"ls", "-l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            }
        }
    }

    public static class LinkStats {
        public int countDirs = 0;
        public int countSingleLinks = 0;
        public int countMultLinks = 0;
        public int countFilesMultLinks = 0;
        public int countEmptyDirs = 0;
        public int countPhysicalFileCopies = 0;

        public void clear() {
            this.countDirs = 0;
            this.countSingleLinks = 0;
            this.countMultLinks = 0;
            this.countFilesMultLinks = 0;
            this.countEmptyDirs = 0;
            this.countPhysicalFileCopies = 0;
        }

        public String report() {
            return "HardLinkStats: " + this.countDirs + " Directories, including " + this.countEmptyDirs + " Empty Directories, " + this.countSingleLinks + " single Link operations, " + this.countMultLinks + " multi-Link operations, linking " + this.countFilesMultLinks + " files, total " + (this.countSingleLinks + this.countFilesMultLinks) + " linkable files.  Also physically copied " + this.countPhysicalFileCopies + " other files.";
        }
    }

    static class HardLinkCGWin
    extends HardLinkCommandGetter {
        static String CMD_EXE = "cmd.exe";
        static String[] hardLinkCommand = new String[]{Shell.WINUTILS, "hardlink", "create", null, null};
        static String[] hardLinkMultPrefix = new String[]{CMD_EXE, "/q", "/c", "for", "%f", "in", "("};
        static String hardLinkMultDir = "\\%f";
        static String[] hardLinkMultSuffix = new String[]{")", "do", Shell.WINUTILS, "hardlink", "create", null, "%f"};
        static String[] getLinkCountCommand = new String[]{Shell.WINUTILS, "hardlink", "stat", null};
        static final int maxAllowedCmdArgLength = 8127;

        HardLinkCGWin() {
        }

        @Override
        String[] linkOne(File file, File linkName) throws IOException {
            String[] buf = new String[hardLinkCommand.length];
            System.arraycopy(hardLinkCommand, 0, buf, 0, hardLinkCommand.length);
            buf[4] = file.getCanonicalPath();
            buf[3] = linkName.getCanonicalPath();
            return buf;
        }

        @Override
        String[] linkMult(String[] fileBaseNames, File linkDir) throws IOException {
            String[] buf = new String[fileBaseNames.length + hardLinkMultPrefix.length + hardLinkMultSuffix.length];
            String td = linkDir.getCanonicalPath() + hardLinkMultDir;
            int mark = 0;
            System.arraycopy(hardLinkMultPrefix, 0, buf, mark, hardLinkMultPrefix.length);
            System.arraycopy(fileBaseNames, 0, buf, mark += hardLinkMultPrefix.length, fileBaseNames.length);
            System.arraycopy(hardLinkMultSuffix, 0, buf, mark += fileBaseNames.length, hardLinkMultSuffix.length);
            buf[(mark += HardLinkCGWin.hardLinkMultSuffix.length) - 2] = td;
            return buf;
        }

        @Override
        String[] linkCount(File file) throws IOException {
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGWin.getLinkCountCommand.length - 1] = file.getCanonicalPath();
            return buf;
        }

        @Override
        int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
            int sum = 0;
            for (String x : fileBaseNames) {
                sum += 1 + (x == null ? 0 : x.length());
            }
            sum += 2 + fileDir.getCanonicalPath().length() + linkDir.getCanonicalPath().length();
            return sum += (CMD_EXE + " /q /c for %f in ( ) do " + Shell.WINUTILS + " hardlink create \\%f %f").length();
        }

        @Override
        int getMaxAllowedCmdArgLength() {
            return 8127;
        }
    }

    static class HardLinkCGUnix
    extends HardLinkCommandGetter {
        private static String[] hardLinkCommand = new String[]{"ln", null, null};
        private static String[] hardLinkMultPrefix = new String[]{"ln"};
        private static String[] hardLinkMultSuffix = new String[]{null};
        private static String[] getLinkCountCommand = new String[]{"stat", "-c%h", null};
        private static final int maxAllowedCmdArgLength = 32703;

        HardLinkCGUnix() {
        }

        private static synchronized void setLinkCountCmdTemplate(String[] template) {
            getLinkCountCommand = template;
        }

        @Override
        String[] linkOne(File file, File linkName) throws IOException {
            String[] buf = new String[hardLinkCommand.length];
            System.arraycopy(hardLinkCommand, 0, buf, 0, hardLinkCommand.length);
            buf[1] = FileUtil.makeShellPath(file, true);
            buf[2] = FileUtil.makeShellPath(linkName, true);
            return buf;
        }

        @Override
        String[] linkMult(String[] fileBaseNames, File linkDir) throws IOException {
            String[] buf = new String[fileBaseNames.length + hardLinkMultPrefix.length + hardLinkMultSuffix.length];
            int mark = 0;
            System.arraycopy(hardLinkMultPrefix, 0, buf, mark, hardLinkMultPrefix.length);
            System.arraycopy(fileBaseNames, 0, buf, mark += hardLinkMultPrefix.length, fileBaseNames.length);
            buf[mark += fileBaseNames.length] = FileUtil.makeShellPath(linkDir, true);
            return buf;
        }

        @Override
        String[] linkCount(File file) throws IOException {
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGUnix.getLinkCountCommand.length - 1] = FileUtil.makeShellPath(file, true);
            return buf;
        }

        @Override
        int getLinkMultArgLength(File fileDir, String[] fileBaseNames, File linkDir) throws IOException {
            int sum = 0;
            for (String x : fileBaseNames) {
                sum += 1 + (x == null ? 0 : x.length());
            }
            sum += 2 + FileUtil.makeShellPath(fileDir, true).length() + FileUtil.makeShellPath(linkDir, true).length();
            return sum += 3;
        }

        @Override
        int getMaxAllowedCmdArgLength() {
            return 32703;
        }
    }

    private static abstract class HardLinkCommandGetter {
        private HardLinkCommandGetter() {
        }

        abstract String[] linkMult(String[] var1, File var2) throws IOException;

        abstract String[] linkOne(File var1, File var2) throws IOException;

        abstract String[] linkCount(File var1) throws IOException;

        abstract int getLinkMultArgLength(File var1, String[] var2, File var3) throws IOException;

        abstract int getMaxAllowedCmdArgLength();
    }
}

