/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.locationtech.geomesa.bigtable.spark.BigtableInputFormat;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001b\tQr)Z8NKN\f')[4uC\ndW-\u00138qkR4uN]7bi*\u00111\u0001B\u0001\u0006gB\f'o\u001b\u0006\u0003\u000b\u0019\t\u0001BY5hi\u0006\u0014G.\u001a\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001d!r\u0003\u0003B\b\u00171yi\u0011\u0001\u0005\u0006\u0003#I\t\u0011\"\\1qe\u0016$WoY3\u000b\u0005M!\u0012A\u00025bI>|\u0007O\u0003\u0002\u0016\u0015\u00051\u0011\r]1dQ\u0016L!a\u0006\t\u0003\u0017%s\u0007/\u001e;G_Jl\u0017\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00037I\t!![8\n\u0005uQ\"\u0001\u0002+fqR\u0004\"a\b\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\rMLW\u000e\u001d7f\u0015\t\u0019C%A\u0004gK\u0006$XO]3\u000b\u0005\u0015R\u0011aB8qK:<\u0017n]\u0005\u0003O\u0001\u0012QbU5na2,g)Z1ukJ,\u0007CA\u0015-\u001b\u0005Q#BA\u0016\u0013\u0003\u0011\u0019wN\u001c4\n\u00055R#\u0001D\"p]\u001aLw-\u001e:bE2,\u0007CA\u00187\u001b\u0005\u0001$BA\u00193\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0019D'\u0001\u0005usB,7/\u00194f\u0015\u0005)\u0014aA2p[&\u0011q\u0007\r\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002\u0005!9a\b\u0001b\u0001\n\u0013y\u0014\u0001\u00033fY\u0016<\u0017\r^3\u0016\u0003\u0001\u0003\"\u0001P!\n\u0005\t\u0013!a\u0005\"jOR\f'\r\\3J]B,HOR8s[\u0006$\bB\u0002#\u0001A\u0003%\u0001)A\u0005eK2,w-\u0019;fA!I1\u0006\u0001a\u0001\u0002\u0004%IAR\u000b\u0002\u000fB\u0011\u0011\u0006S\u0005\u0003\u0013*\u0012QbQ8oM&<WO]1uS>t\u0007\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0003M\u0003!\u0019wN\u001c4`I\u0015\fHCA'T!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0011)f.\u001b;\t\u000fQS\u0015\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\rY\u0003\u0001\u0015)\u0003H\u0003\u0015\u0019wN\u001c4!\u0011\u0015A\u0006\u0001\"\u0011Z\u0003%9W\r^*qY&$8\u000f\u0006\u0002[KB\u00191\f\u00192\u000e\u0003qS!!\u00180\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0003MSN$\bCA\bd\u0013\t!\u0007C\u0001\u0006J]B,Ho\u00159mSRDQAZ,A\u0002\u001d\fqaY8oi\u0016DH\u000f\u0005\u0002\u0010Q&\u0011\u0011\u000e\u0005\u0002\u000b\u0015>\u00147i\u001c8uKb$\b\"B6\u0001\t\u0003b\u0017AE2sK\u0006$XMU3d_J$'+Z1eKJ$2!\u001c9s!\u0011ya\u000e\u0007\u0010\n\u0005=\u0004\"\u0001\u0004*fG>\u0014HMU3bI\u0016\u0014\b\"B9k\u0001\u0004\u0011\u0017!B:qY&$\b\"\u00024k\u0001\u0004\u0019\bCA\bu\u0013\t)\bC\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\"B<\u0001\t\u0003B\u0018aB:fi\u000e{gN\u001a\u000b\u0003\u001bfDQa\u000b<A\u0002\u001dCQa\u001f\u0001\u0005Bq\fqaZ3u\u0007>tg\rF\u0001H\u0001")
public class GeoMesaBigtableInputFormat
extends InputFormat<Text, SimpleFeature>
implements Configurable,
LazyLogging {
    private final BigtableInputFormat delegate;
    private Configuration conf;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaBigtableInputFormat geoMesaBigtableInputFormat = this;
        synchronized (geoMesaBigtableInputFormat) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private BigtableInputFormat delegate() {
        return this.delegate;
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public List<InputSplit> getSplits(JobContext context) {
        void var2_2;
        BoxedUnit boxedUnit;
        List<InputSplit> splits = this.delegate().getSplits(context);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Got {} splits", new Object[]{BoxesRunTime.boxToInteger((int)splits.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public RecordReader<Text, SimpleFeature> createRecordReader(InputSplit split, TaskAttemptContext context) {
        QueryPlan.ResultsToFeatures toFeatures = GeoMesaConfigurator$.MODULE$.getResultsToFeatures(context.getConfiguration());
        Option reducer = GeoMesaConfigurator$.MODULE$.getReducer(context.getConfiguration());
        return new GeoMesaHBaseInputFormat.GeoMesaHBaseRecordReader(toFeatures, reducer, this.delegate().createRecordReader(split, context));
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(conf);
        this.delegate().setConf(conf);
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
    }

    public Configuration getConf() {
        return this.conf();
    }

    public GeoMesaBigtableInputFormat() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.delegate = new BigtableInputFormat();
    }
}

