/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPosition3D
implements DirectPosition,
Serializable,
Cloneable {
    public double x;
    public double y;
    public double z;
    private static final long serialVersionUID = 835130287438466996L;
    private CoordinateReferenceSystem crs;

    public DirectPosition3D() {
    }

    public DirectPosition3D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DirectPosition3D(CoordinateReferenceSystem crs, double x, double y, double z) {
        this(x, y, z);
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition3D(DirectPosition point) {
        this.setLocation(point);
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(crs, 3);
        this.crs = crs;
    }

    public final int getDimension() {
        return 3;
    }

    public double[] getCoordinate() {
        return new double[]{this.x, this.y, this.z};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(dimension));
            }
        }
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), 3);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
        this.z = position.getOrdinate(2);
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition other = (DirectPosition)object;
            if (other.getDimension() == 3 && Utilities.equals((double)other.getOrdinate(0), (double)this.x) && Utilities.equals((double)other.getOrdinate(1), (double)this.y) && Utilities.equals((double)other.getOrdinate(2), (double)this.z) && Utilities.equals((Object)other.getCoordinateReferenceSystem(), (Object)this.crs)) {
                assert (this.hashCode() == other.hashCode()) : this;
                return true;
            }
            return false;
        }
        return false;
    }

    public DirectPosition3D clone() {
        return new DirectPosition3D(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }
}

