/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.data.util.DelegateProgressListener;
import org.opengis.util.ProgressListener;

public class SubProgressListener
extends DelegateProgressListener {
    float start;
    float amount;
    float scale;
    float progress;

    public SubProgressListener(ProgressListener progress, float start, float amount) {
        super(progress);
        this.start = start;
        this.amount = amount > 0.0f ? amount : 0.0f;
        this.scale = this.amount / 100.0f;
    }

    public SubProgressListener(ProgressListener progress, float amount) {
        this(progress, progress.getProgress(), amount);
    }

    @Override
    public void started() {
        this.progress = 0.0f;
        if (this.start == 0.0f) {
            super.started();
        }
    }

    @Override
    public void complete() {
        this.delegate.progress(this.start + this.amount);
        this.progress = 100.0f;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void progress(float progress) {
        this.progress = progress;
        super.progress(this.start + this.scale * progress);
    }
}

