/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class LiteralDemultiplyingFilterVisitor
extends DuplicatingFilterVisitor {
    protected <T extends MultiValuedFilter> Filter demultiplyFirst(T filter, FilterReplacer<T> replacer) {
        Literal l;
        Object value;
        Expression one = replacer.getExpression1(filter);
        Expression two = replacer.getExpression2(filter);
        if (one instanceof Literal && (value = (l = (Literal)one).getValue()) instanceof Collection) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (Object valueElement : (Collection)value) {
                filters.add(replacer.replaceExpressions(filter, (Expression)this.ff.literal(valueElement), two));
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ANY) {
                return this.ff.or(filters);
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ALL) {
                return this.ff.and(filters);
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ONE) {
                ArrayList<And> filters2 = new ArrayList<And>();
                for (int i = 0; i < filters.size(); ++i) {
                    ArrayList filters3 = new ArrayList();
                    for (int j = 0; j < filters.size(); ++j) {
                        if (i == j) {
                            filters3.add(filters.get(j));
                            continue;
                        }
                        filters3.add(this.ff.not((Filter)filters.get(j)));
                    }
                    filters2.add(this.ff.and(filters3));
                }
                return this.ff.or(filters2);
            }
        }
        return filter;
    }

    protected <T extends MultiValuedFilter> Filter demultiply(T filter, FilterReplacer<T> replacer) {
        Literal l;
        Object value;
        Expression one = replacer.getExpression1(filter);
        Expression two = replacer.getExpression2(filter);
        if (two instanceof Literal && (value = (l = (Literal)two).getValue()) instanceof Collection) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (Object valueElement : (Collection)value) {
                filters.add(this.demultiplyFirst((MultiValuedFilter)replacer.replaceExpressions(filter, one, (Expression)this.ff.literal(valueElement)), replacer));
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ANY) {
                return this.ff.or(filters);
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ALL) {
                return this.ff.and(filters);
            }
            if (filter.getMatchAction() == MultiValuedFilter.MatchAction.ONE) {
                ArrayList<And> filters2 = new ArrayList<And>();
                for (int i = 0; i < filters.size(); ++i) {
                    ArrayList filters3 = new ArrayList();
                    for (int j = 0; j < filters.size(); ++j) {
                        if (i == j) {
                            filters3.add(filters.get(j));
                            continue;
                        }
                        filters3.add(this.ff.not((Filter)filters.get(j)));
                    }
                    filters2.add(this.ff.and(filters3));
                }
                return this.ff.or(filters2);
            }
        }
        return this.demultiplyFirst(filter, replacer);
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        return super.visit(filter, extraData);
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("equal"));
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("notEqual"));
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("greater"));
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("greaterOrEqual"));
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("less"));
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinaryComparisonOperatorReplacer("lessOrEqual"));
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("bbox"));
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        return this.demultiply(filter, new FilterReplacer<Beyond>(){

            @Override
            public Expression getExpression1(Beyond filter) {
                return filter.getExpression1();
            }

            @Override
            public Expression getExpression2(Beyond filter) {
                return filter.getExpression2();
            }

            @Override
            public Filter replaceExpressions(Beyond filter, Expression expression1, Expression expression2) {
                return LiteralDemultiplyingFilterVisitor.this.ff.beyond(expression1, expression2, filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
            }
        });
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("contains"));
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("crosses"));
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("disjoint"));
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        return this.demultiply(filter, new FilterReplacer<DWithin>(){

            @Override
            public Expression getExpression1(DWithin filter) {
                return filter.getExpression1();
            }

            @Override
            public Expression getExpression2(DWithin filter) {
                return filter.getExpression2();
            }

            @Override
            public Filter replaceExpressions(DWithin filter, Expression expression1, Expression expression2) {
                return LiteralDemultiplyingFilterVisitor.this.ff.dwithin(expression1, expression2, filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
            }
        });
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("equal"));
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("intersects"));
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("overlaps"));
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("touches"));
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        return this.demultiply((MultiValuedFilter)filter, new BinarySpatialOperatorReplacer("within"));
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.demultiply((MultiValuedFilter)after, new BinaryTemporalOperatorReplacer("after"));
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.demultiply((MultiValuedFilter)anyInteracts, new BinaryTemporalOperatorReplacer("anyInteracts"));
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.demultiply((MultiValuedFilter)before, new BinaryTemporalOperatorReplacer("before"));
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.demultiply((MultiValuedFilter)begins, new BinaryTemporalOperatorReplacer("begins"));
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.demultiply((MultiValuedFilter)begunBy, new BinaryTemporalOperatorReplacer("begunBy"));
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.demultiply((MultiValuedFilter)during, new BinaryTemporalOperatorReplacer("during"));
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.demultiply((MultiValuedFilter)endedBy, new BinaryTemporalOperatorReplacer("endedBy"));
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.demultiply((MultiValuedFilter)ends, new BinaryTemporalOperatorReplacer("ends"));
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.demultiply((MultiValuedFilter)meets, new BinaryTemporalOperatorReplacer("meets"));
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.demultiply((MultiValuedFilter)metBy, new BinaryTemporalOperatorReplacer("metBy"));
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.demultiply((MultiValuedFilter)overlappedBy, new BinaryTemporalOperatorReplacer("overlappedBy"));
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.demultiply((MultiValuedFilter)contains, new BinaryTemporalOperatorReplacer("tcontains"));
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.demultiply((MultiValuedFilter)equals, new BinaryTemporalOperatorReplacer("tequals"));
    }

    @Override
    public Object visit(TOverlaps overlaps, Object extraData) {
        return this.demultiply((MultiValuedFilter)overlaps, new BinaryTemporalOperatorReplacer("toverlaps"));
    }

    protected class BinaryTemporalOperatorReplacer
    implements FilterReplacer<BinaryTemporalOperator> {
        protected Method method;

        public BinaryTemporalOperatorReplacer(String methodName) {
            try {
                this.method = LiteralDemultiplyingFilterVisitor.this.ff.getClass().getMethod(methodName, Expression.class, Expression.class, MultiValuedFilter.MatchAction.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Expression getExpression1(BinaryTemporalOperator filter) {
            return filter.getExpression1();
        }

        @Override
        public Expression getExpression2(BinaryTemporalOperator filter) {
            return filter.getExpression2();
        }

        @Override
        public Filter replaceExpressions(BinaryTemporalOperator filter, Expression expression1, Expression expression2) {
            try {
                return (Filter)this.method.invoke((Object)LiteralDemultiplyingFilterVisitor.this.ff, expression1, expression2, filter.getMatchAction());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class BinarySpatialOperatorReplacer
    implements FilterReplacer<BinarySpatialOperator> {
        protected Method method;

        public BinarySpatialOperatorReplacer(String methodName) {
            try {
                this.method = LiteralDemultiplyingFilterVisitor.this.ff.getClass().getMethod(methodName, Expression.class, Expression.class, MultiValuedFilter.MatchAction.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Expression getExpression1(BinarySpatialOperator filter) {
            return filter.getExpression1();
        }

        @Override
        public Expression getExpression2(BinarySpatialOperator filter) {
            return filter.getExpression2();
        }

        @Override
        public Filter replaceExpressions(BinarySpatialOperator filter, Expression expression1, Expression expression2) {
            try {
                return (Filter)this.method.invoke((Object)LiteralDemultiplyingFilterVisitor.this.ff, expression1, expression2, filter.getMatchAction());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class BinaryComparisonOperatorReplacer
    implements FilterReplacer<BinaryComparisonOperator> {
        protected Method method;

        public BinaryComparisonOperatorReplacer(String methodName) {
            try {
                this.method = LiteralDemultiplyingFilterVisitor.this.ff.getClass().getMethod(methodName, Expression.class, Expression.class, Boolean.TYPE, MultiValuedFilter.MatchAction.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Expression getExpression1(BinaryComparisonOperator filter) {
            return filter.getExpression1();
        }

        @Override
        public Expression getExpression2(BinaryComparisonOperator filter) {
            return filter.getExpression2();
        }

        @Override
        public Filter replaceExpressions(BinaryComparisonOperator filter, Expression expression1, Expression expression2) {
            try {
                return (Filter)this.method.invoke((Object)LiteralDemultiplyingFilterVisitor.this.ff, expression1, expression2, filter.isMatchingCase(), filter.getMatchAction());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static interface FilterReplacer<F extends MultiValuedFilter> {
        public Expression getExpression1(F var1);

        public Expression getExpression2(F var1);

        public Filter replaceExpressions(F var1, Expression var2, Expression var3);
    }
}

