/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public enum Geometries {
    POINT(Point.class, 2001),
    LINESTRING(LineString.class, 2002),
    POLYGON(Polygon.class, 2003),
    MULTIPOINT(MultiPoint.class, 2004),
    MULTILINESTRING(MultiLineString.class, 2005),
    MULTIPOLYGON(MultiPolygon.class, 2006),
    GEOMETRY(Geometry.class, 2007),
    GEOMETRYCOLLECTION(GeometryCollection.class, 2008);

    private final Class<? extends Geometry> binding;
    private final int sqlType;
    private final String name;
    private final String simpleName;

    private Geometries(Class<? extends Geometry> type, int sqlType) {
        this.binding = type;
        this.sqlType = sqlType;
        this.name = type.getSimpleName();
        this.simpleName = this.name.startsWith("Multi") ? this.name.substring(5) : this.name;
    }

    public Class<? extends Geometry> getBinding() {
        return this.binding;
    }

    public Integer getSQLType() {
        return this.sqlType;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public static Geometries get(Geometry geom) {
        if (geom != null) {
            return Geometries.getForBinding(geom.getClass());
        }
        return null;
    }

    public static Geometries getForBinding(Class<? extends Geometry> geomClass) {
        for (Geometries gt : Geometries.values()) {
            if (gt.binding != geomClass) continue;
            return gt;
        }
        Geometries match = null;
        for (Geometries gt : Geometries.values()) {
            if (gt == GEOMETRY || gt == GEOMETRYCOLLECTION || !gt.binding.isAssignableFrom(geomClass)) continue;
            if (match == null) {
                match = gt;
                continue;
            }
            return null;
        }
        if (match == null) {
            if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                return GEOMETRYCOLLECTION;
            }
            if (Geometry.class.isAssignableFrom(geomClass)) {
                return GEOMETRY;
            }
        }
        return match;
    }

    public static Geometries getForName(String name) {
        for (Geometries gt : Geometries.values()) {
            if (!gt.getName().equalsIgnoreCase(name)) continue;
            return gt;
        }
        return null;
    }

    public static Geometries getForSQLType(int sqlType) {
        for (Geometries gt : Geometries.values()) {
            if (gt.sqlType != sqlType) continue;
            return gt;
        }
        return null;
    }
}

