/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.util.LazySet;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProjectionHandlerFinder {
    private static FactoryRegistry registry;
    static final Logger LOGGER;
    public static final String WRAP_LIMIT_KEY = "org.geotools.render.wrapLimit";
    static int WRAP_LIMIT;

    public void setWrapLimit(int wrapLimit) {
        WRAP_LIMIT = wrapLimit;
    }

    private static LazySet<ProjectionHandlerFactory> getProjectionHandlerFactories() {
        Hints hints = GeoTools.getDefaultHints();
        return new LazySet(registry.getFactories(ProjectionHandlerFactory.class, null, hints));
    }

    public static ProjectionHandler getHandler(ReferencedEnvelope renderingArea, CoordinateReferenceSystem sourceCrs, boolean wrap) throws FactoryException {
        if (renderingArea.getCoordinateReferenceSystem() == null) {
            return null;
        }
        for (ProjectionHandlerFactory factory : ProjectionHandlerFinder.getProjectionHandlerFactories()) {
            ProjectionHandler handler = factory.getHandler(renderingArea, sourceCrs, wrap, WRAP_LIMIT);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    static {
        LOGGER = Logging.getLogger(ProjectionHandlerFinder.class);
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(ProjectionHandlerFactory.class));
        }
        String wrapLimit = System.getProperty(WRAP_LIMIT_KEY);
        int limit = 10;
        try {
            if (wrapLimit != null) {
                limit = Integer.valueOf(wrapLimit);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.SEVERE, "org.geotools.render.wrapLimit has invalid value, it should be an integer number but it was: " + wrapLimit);
        }
        WRAP_LIMIT = limit;
    }
}

