/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class ShadedReliefImpl
implements ShadedRelief {
    private FilterFactory filterFactory;
    private Expression reliefFactor;
    private boolean brightness = false;

    public ShadedReliefImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public ShadedReliefImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.reliefFactor = this.filterFactory.literal(55);
    }

    public Expression getReliefFactor() {
        return this.reliefFactor;
    }

    public boolean isBrightnessOnly() {
        return this.brightness;
    }

    @Override
    public void setBrightnessOnly(boolean flag) {
        this.brightness = flag;
    }

    @Override
    public void setReliefFactor(Expression reliefFactor) {
        this.reliefFactor = reliefFactor;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.ShadedRelief)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.reliefFactor != null) {
            result = 1000003 * result + this.reliefFactor.hashCode();
        }
        result = 1000003 * result + (this.brightness ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShadedReliefImpl) {
            ShadedReliefImpl other = (ShadedReliefImpl)obj;
            return Utilities.equals((Object)this.reliefFactor, (Object)other.reliefFactor) && Utilities.equals((boolean)this.brightness, (boolean)other.brightness);
        }
        return false;
    }

    static ShadedReliefImpl cast(org.opengis.style.ShadedRelief shadedRelief) {
        if (shadedRelief == null) {
            return null;
        }
        if (shadedRelief instanceof ShadedReliefImpl) {
            return (ShadedReliefImpl)shadedRelief;
        }
        ShadedReliefImpl copy = new ShadedReliefImpl();
        copy.setBrightnessOnly(shadedRelief.isBrightnessOnly());
        copy.setReliefFactor(shadedRelief.getReliefFactor());
        return copy;
    }
}

