/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs20.FeatureCollectionType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.gml3.bindings.FeaturePropertyTypeBinding;
import org.geotools.gml3.v3_2.GML;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.geotools.xsd.SchemaIndex;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeType;

public class MemberPropertyTypeBinding
extends FeaturePropertyTypeBinding {
    SchemaIndex schemaIndex;

    public MemberPropertyTypeBinding(XSDIdRegistry idSet, SchemaIndex schemaIndex) {
        super(idSet);
        this.schemaIndex = schemaIndex;
    }

    public QName getTarget() {
        return WFS.MemberPropertyType;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return super.parse(instance, node, value);
    }

    public List getProperties(Object object, XSDElementDeclaration element) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object member = super.getProperty(object, org.geotools.gml3.GML._Feature);
        if (member != null) {
            if (GMLEncodingUtils.isJoinedFeature((Object)member)) {
                list.add(new Object[]{WFS.Tuple, GMLEncodingUtils.splitJoinedFeature((Object)member)});
            } else {
                list.add(new Object[]{GML.AbstractFeature, object});
            }
        } else if (object instanceof FeatureCollectionType) {
            list.add(new Object[]{WFS.FeatureCollection, object});
        } else if (object instanceof Attribute) {
            Attribute att = (Attribute)object;
            list.add(new Object[]{this.particle(att), att.getValue()});
        }
        return list;
    }

    XSDParticle particle(Attribute att) {
        XSDFactory factory = XSDFactory.eINSTANCE;
        AttributeType attType = att.getType();
        XSDTypeDefinition xsdType = this.schemaIndex.getTypeDefinition(new QName(attType.getName().getNamespaceURI(), attType.getName().getLocalPart()));
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(att.getName().getLocalPart());
        element.setTargetNamespace(att.getName().getNamespaceURI());
        element.setTypeDefinition(xsdType);
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        return particle;
    }
}

