/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import com.google.common.util.concurrent.AtomicDouble;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;

public class HistogramMode
extends Statistics {
    private final boolean histogramStat;
    private final int numBins;
    private final Range interval;
    private final double binInterval;
    private final double minBound;
    private final AtomicDouble[] bins;

    HistogramMode(int numBins, double minBound, double maxBound, boolean histogramStat) {
        this.histogramStat = histogramStat;
        this.numBins = numBins;
        if (minBound == Double.NEGATIVE_INFINITY) {
            minBound = -8.988465674311579E307;
        }
        if (maxBound == Double.POSITIVE_INFINITY) {
            maxBound = 8.988465674311579E307;
        }
        this.interval = RangeFactory.create((double)minBound, (boolean)true, (double)maxBound, (boolean)false, (boolean)false);
        this.binInterval = (maxBound - minBound) / (double)numBins;
        this.minBound = minBound;
        this.bins = new AtomicDouble[numBins];
        for (int i = 0; i < numBins; ++i) {
            this.bins[i] = new AtomicDouble(0.0);
        }
        this.type = histogramStat ? Statistics.StatsType.HISTOGRAM : Statistics.StatsType.MODE;
    }

    @Override
    public void addSample(double sample) {
        ++this.samples;
        if (this.interval.contains(sample)) {
            int index = this.getIndex(sample);
            this.bins[index].addAndGet(1.0);
        }
    }

    @Override
    protected void accumulateStats(Statistics stats) {
        throw new UnsupportedOperationException("Histogram statistics cannot be accumulated");
    }

    @Override
    public Object getResult() {
        if (this.histogramStat) {
            double[] array = new double[this.numBins];
            for (int i = 0; i < this.numBins; ++i) {
                array[i] = this.bins[i].doubleValue();
            }
            return array;
        }
        double max = 0.0;
        int indexMax = 0;
        for (int i = 0; i < this.numBins; ++i) {
            if (!(this.bins[i].doubleValue() > max)) continue;
            max = this.bins[i].doubleValue();
            indexMax = i;
        }
        if (max == 0.0) {
            return (double)indexMax * 1.0;
        }
        return (double)indexMax + this.minBound;
    }

    @Override
    public Long getNumSamples() {
        return this.samples;
    }

    @Override
    protected synchronized void clearStats() {
        for (int i = 0; i < this.numBins; ++i) {
            this.bins[i] = new AtomicDouble(0.0);
        }
    }

    private int getIndex(double sample) {
        int index = (int)((sample - this.minBound) / this.binInterval);
        return index;
    }
}

