/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.stats.Extrema;
import it.geosolutions.jaiext.stats.HistogramMode;
import it.geosolutions.jaiext.stats.Max;
import it.geosolutions.jaiext.stats.MeanSum;
import it.geosolutions.jaiext.stats.Median;
import it.geosolutions.jaiext.stats.Min;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.VarianceStd;

public class StatsFactory {
    private StatsFactory() {
    }

    public static Statistics createMeanObject() {
        return new MeanSum(false);
    }

    public static Statistics createSumObject() {
        return new MeanSum(true);
    }

    public static Statistics createMaxObject() {
        return new Max();
    }

    public static Statistics createMinObject() {
        return new Min();
    }

    public static Statistics createExtremaObject() {
        return new Extrema();
    }

    public static Statistics createVarianceObject() {
        return new VarianceStd(true);
    }

    public static Statistics createDevStdObject() {
        return new VarianceStd(false);
    }

    public static Statistics createHistogramObject(int numBins, double minBound, double maxBound) {
        return new HistogramMode(numBins, minBound, maxBound, true);
    }

    public static Statistics createModeObject(int numBins, double minBound, double maxBound) {
        return new HistogramMode(numBins, minBound, maxBound, false);
    }

    public static Statistics createMedianObject(double minBound, double maxBound) {
        return new Median(minBound, maxBound);
    }

    public static Statistics createSimpleStatisticsObjectFromInt(int value) {
        Statistics.StatsType type = Statistics.StatsType.values()[value];
        switch (type) {
            case MEAN: {
                return StatsFactory.createMeanObject();
            }
            case SUM: {
                return StatsFactory.createSumObject();
            }
            case MAX: {
                return StatsFactory.createMaxObject();
            }
            case MIN: {
                return StatsFactory.createMinObject();
            }
            case EXTREMA: {
                return StatsFactory.createExtremaObject();
            }
            case VARIANCE: {
                return StatsFactory.createVarianceObject();
            }
            case DEV_STD: {
                return StatsFactory.createDevStdObject();
            }
        }
        throw new IllegalArgumentException("Wrong StatsType object selected");
    }

    public static Statistics createComplexStatisticsObjectFromInt(int value, double minBound, double maxBound, int numBins) {
        Statistics.StatsType type = Statistics.StatsType.values()[value];
        switch (type) {
            case HISTOGRAM: {
                return StatsFactory.createHistogramObject(numBins, minBound, maxBound);
            }
            case MODE: {
                return StatsFactory.createModeObject(numBins, minBound, maxBound);
            }
            case MEDIAN: {
                return StatsFactory.createMedianObject(minBound, maxBound);
            }
        }
        throw new IllegalArgumentException("Wrong StatsType object selected");
    }
}

