/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.data;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.locationtech.geomesa.bigtable.data.BigtableDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\t!\")[4uC\ndW-\u00138eKb\fE-\u00199uKJT!a\u0001\u0003\u0002\t\u0011\fG/\u0019\u0006\u0003\u000b\u0019\t\u0001BY5hi\u0006\u0014G.\u001a\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qbE\u0007\u0002!)\u00111!\u0005\u0006\u0003%\u0019\tQ\u0001\u001b2bg\u0016L!\u0001\u0006\t\u0003#!\u0013\u0015m]3J]\u0012,\u00070\u00113baR,'\u000f\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\t!7\u000f\u0005\u0002\u001935\t!!\u0003\u0002\u001b\u0005\t\t\")[4uC\ndW\rR1uCN#xN]3\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\tqr\u0004\u0005\u0002\u0019\u0001!)ac\u0007a\u0001/!9\u0011\u0005\u0001b\u0001\n\u0003\u0012\u0013A\u0004;bE2,g*Y7f\u0019&l\u0017\u000e^\u000b\u0002GA\u0019AeJ\u0015\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012aa\u00149uS>t\u0007C\u0001\u0013+\u0013\tYSEA\u0002J]RDa!\f\u0001!\u0002\u0013\u0019\u0013a\u0004;bE2,g*Y7f\u0019&l\u0017\u000e\u001e\u0011\t\u000b=\u0002A\u0011\u000b\u0019\u0002\u001d\r|gNZ5hkJ,7kY1ogR)\u0011\u0007\u0013&S7B\u0019!GO\u001f\u000f\u0005MBdB\u0001\u001b8\u001b\u0005)$B\u0001\u001c\r\u0003\u0019a$o\\8u}%\ta%\u0003\u0002:K\u00059\u0001/Y2lC\u001e,\u0017BA\u001e=\u0005\r\u0019V-\u001d\u0006\u0003s\u0015\u0002\"A\u0010$\u000e\u0003}R!\u0001Q!\u0002\r\rd\u0017.\u001a8u\u0015\t\u0011\"I\u0003\u0002D\t\u00061\u0001.\u00193p_BT!!\u0012\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t9uH\u0001\u0003TG\u0006t\u0007\"B%/\u0001\u0004\t\u0014AD8sS\u001eLg.\u00197SC:<Wm\u001d\u0005\u0006\u0017:\u0002\r\u0001T\u0001\nG>dg)Y7jYf\u00042\u0001J'P\u0013\tqUEA\u0003BeJ\f\u0017\u0010\u0005\u0002%!&\u0011\u0011+\n\u0002\u0005\u0005f$X\rC\u0003T]\u0001\u0007A+A\u0004gS2$XM]:\u0011\u0007IRT\u000b\u0005\u0002W36\tqK\u0003\u0002Y\u0003\u00061a-\u001b7uKJL!AW,\u0003\r\u0019KG\u000e^3s\u0011\u0015af\u00061\u0001^\u0003-\u0019w\u000e\u001d:pG\u0016\u001c8o\u001c:\u0011\u0005\u0011r\u0016BA0&\u0005\u001d\u0011un\u001c7fC:\u0004")
public class BigtableIndexAdapter
extends HBaseIndexAdapter {
    private final BigtableDataStore ds;
    private final Option<Object> tableNameLimit;

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public Seq<Scan> configureScans(Seq<Scan> originalRanges, byte[] colFamily, Seq<Filter> filters, boolean coprocessor) {
        Seq seq;
        if (filters.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bigtable doesn't support filters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filters.mkString(", ")})));
        }
        if (originalRanges.headOption().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Scan x$1) {
                return x$1.isSmall();
            }
        })) {
            seq = (Seq)originalRanges.map((Function1)new Serializable(this, colFamily){
                public static final long serialVersionUID = 0L;
                private final byte[] colFamily$1;

                public final Scan apply(Scan s) {
                    return new Scan(s).addFamily(this.colFamily$1);
                }
                {
                    this.colFamily$1 = colFamily$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            List sortedRowRanges = HBaseIndexAdapter$.MODULE$.sortAndMerge(originalRanges);
            int numRanges = sortedRowRanges.size();
            int numThreads = this.ds.config().queryThreads();
            int rangesPerThread = package$.MODULE$.min(this.ds.config().maxRangesPerExtendedScan(), package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(numRanges / numThreads * 2))));
            List groupedRanges = Lists.partition((List)sortedRowRanges, (int)rangesPerThread);
            Buffer groupedScans = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupedRanges).asScala()).map((Function1)new Serializable(this, colFamily){
                public static final long serialVersionUID = 0L;
                private final byte[] colFamily$1;

                /*
                 * WARNING - void declaration
                 */
                public final BigtableExtendedScan apply(List<MultiRowRangeFilter.RowRange> localRanges) {
                    void var2_2;
                    BigtableExtendedScan scan = new BigtableExtendedScan();
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(localRanges).asScala()).foreach((Function1)new Serializable(this, scan){
                        public static final long serialVersionUID = 0L;
                        private final BigtableExtendedScan scan$1;

                        public final void apply(MultiRowRangeFilter.RowRange r) {
                            this.scan$1.addRange(r.getStartRow(), r.getStopRow());
                        }
                        {
                            this.scan$1 = scan$1;
                        }
                    });
                    scan.addFamily(this.colFamily$1);
                    return var2_2;
                }
                {
                    this.colFamily$1 = colFamily$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            seq = groupedScans;
        }
        return seq;
    }

    public BigtableIndexAdapter(BigtableDataStore ds) {
        this.ds = ds;
        super((HBaseDataStore)ds);
        this.tableNameLimit = new Some((Object)BoxesRunTime.boxToInteger((int)50));
    }
}

