/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class LeafletMapExporter$ {
    public static final LeafletMapExporter$ MODULE$;
    private String[] Template;
    private String IndexHead;
    private String IndexTail;
    private final int MaxFeatures;
    private volatile byte bitmap$0;

    static {
        new LeafletMapExporter$();
    }

    private String[] Template$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.Template = (String[])WithClose$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream("leaflet/index.html"), (Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final String[] apply(InputStream is) {
                        void var2_2;
                        String[] indexArray = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString().split("\\|codegen\\|");
                        Predef$.MODULE$.require(indexArray.length == 2, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Malformed index.html, unable to render map";
                            }
                        });
                        return var2_2;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.Template;
        }
    }

    private String IndexHead$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.IndexHead = (String)Predef$.MODULE$.refArrayOps((Object[])this.Template()).head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.IndexHead;
        }
    }

    private String IndexTail$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.IndexTail = (String)Predef$.MODULE$.refArrayOps((Object[])this.Template()).last();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.IndexTail;
        }
    }

    private String[] Template() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Template$lzycompute() : this.Template;
    }

    public String IndexHead() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.IndexHead$lzycompute() : this.IndexHead;
    }

    public String IndexTail() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.IndexTail$lzycompute() : this.IndexTail;
    }

    public int MaxFeatures() {
        return this.MaxFeatures;
    }

    public boolean configure(ExportCommand.ExportParams params) {
        String large = "The Leaflet map may exhibit performance issues when displaying large numbers of features. For a more robust solution, consider using GeoServer.";
        if (params.maxFeatures() == null) {
            Command$.MODULE$.user().warn(large);
            Command$.MODULE$.user().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting max features to ", ". To override, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.MaxFeatures())}))).append((Object)"please use --max-features").toString());
            params.maxFeatures_$eq(Predef$.MODULE$.int2Integer(this.MaxFeatures()));
        } else if (Predef$.MODULE$.Integer2int(params.maxFeatures()) > this.MaxFeatures()) {
            if (params.force()) {
                Command$.MODULE$.user().warn(large);
            } else {
                Object x$5;
                List<String> x$4;
                String x$3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Would you like to continue anyway (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{large}));
                if (!Prompt$.MODULE$.confirm(x$3, x$4 = Prompt$.MODULE$.confirm$default$2(), x$5 = Prompt$.MODULE$.confirm$default$3(x$3, x$4))) {
                    return false;
                }
            }
        }
        if (params.gzip() != null) {
            Command$.MODULE$.user().warn("Ignoring gzip parameter for Leaflet export");
            params.gzip_$eq(null);
        }
        if (params.file() == null) {
            params.file_$eq((String)package$.MODULE$.props().apply((Object)"user.dir"));
        }
        if (PathUtils$.MODULE$.isRemote(params.file())) {
            if (params.file().endsWith("/")) {
                params.file_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "index.html"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.file()})));
            } else if (FilenameUtils.indexOfExtension((String)params.file()) == -1) {
                params.file_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/index.html"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.file()})));
            }
        } else {
            File file = new File(params.file());
            File destination = file.isDirectory() || !file.exists() && file.getName().indexOf(".") == -1 ? new File(file, "index.html") : file;
            params.file_$eq(destination.getAbsolutePath());
        }
        return true;
    }

    public String getFeatureInfo(SimpleFeatureType sft) {
        String string;
        StringBuilder str = new StringBuilder();
        str.append("    function onEachFeature(feature, layer) {\n");
        if (sft == null) {
            string = str.append("\n    };\n\n").toString();
        } else {
            Buffer attributes = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeDescriptor x$2) {
                    return x$2.getLocalName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = A1 = x1;
                    String string = "geom";
                    Object object = !(A12 != null ? !A12.equals(string) : string != null) ? function1.apply(x1) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", ": \" + feature.properties.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A1, A1}));
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x1) {
                    String string;
                    String string2 = string = x1;
                    String string3 = "geom";
                    boolean bl = string2 != null ? !string2.equals(string3) : string3 != null;
                    return bl;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            str.append("        layer.bindPopup(\"ID: \" + feature.id + \"<br>\" + ");
            str.append("\"GEOM: \" + feature.geometry.type + \"[\" + feature.geometry.coordinates + \"]<br>\" + ");
            string = str.append(attributes.mkString(" + \"<br>\" + "));
        }
        str.append(");\n    }\n\n");
        return str.toString();
    }

    private LeafletMapExporter$() {
        MODULE$ = this;
        this.MaxFeatures = 10000;
    }
}

