/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Tuple<T>
implements Serializable {
    protected final String key;
    protected final T value;
    protected final Map<String, Object> metadata;

    public Tuple(String key, T value) {
        this(key, value, Collections.emptyMap());
    }

    public Tuple(String key, T value, Map<String, Object> metadata) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(value);
        this.key = key;
        this.value = value;
        this.metadata = new HashMap<String, Object>(metadata);
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public Set<String> metadataKeys() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public <T> T getMetadataValue(String key) {
        return (T)this.metadata.get(key);
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (this.key != null ? !this.key.equals(tuple.key) : tuple.key != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(tuple.metadata) : tuple.metadata != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(tuple.value) : tuple.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Tuple{key='" + this.key + '\'' + ", value=" + this.value + ", metadata=" + this.metadata + '}';
    }
}

