/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import org.calrissian.mango.types.encoders.AbstractByteEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class ByteEncoder
extends AbstractByteEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Byte value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return String.format("%02x", value);
    }

    @Override
    public Byte decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.length() == 2 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return (byte)EncodingUtils.fromHex(value);
    }
}

