/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

class EncodingUtils {
    EncodingUtils() {
    }

    protected static long fromHex(String hex) {
        long value = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            value = value << 4 | (long)Character.digit(hex.charAt(i), 16);
        }
        return value;
    }

    protected static String encodeULong(long value) {
        return String.format("%016x", value);
    }

    protected static String encodeUInt(int value) {
        return String.format("%08x", value);
    }

    protected static int normalizeFloat(float value) {
        int intBits = Float.floatToIntBits(value);
        if (intBits < 0) {
            return ~intBits;
        }
        return intBits ^ Integer.MIN_VALUE;
    }

    protected static float denormalizeFloat(int value) {
        if (value > 0) {
            return Float.intBitsToFloat(~value);
        }
        return Float.intBitsToFloat(value ^ Integer.MIN_VALUE);
    }

    protected static long normalizeDouble(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        if (longBits < 0L) {
            return longBits ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return longBits ^ Long.MIN_VALUE;
    }

    protected static double denormalizeDouble(long value) {
        if (value > 0L) {
            return Double.longBitsToDouble(value ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return Double.longBitsToDouble(value ^ Long.MIN_VALUE);
    }
}

