/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import java.util.Date;
import java.util.regex.Matcher;
import org.locationtech.geomesa.utils.conf.FeatureExpiration;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class FeatureExpiration$ {
    public static final FeatureExpiration$ MODULE$;
    private final Regex AttributeRegex;

    static {
        new FeatureExpiration$();
    }

    private Regex AttributeRegex() {
        return this.AttributeRegex;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FeatureExpiration apply(SimpleFeatureType sft, String expiration) {
        FeatureExpiration featureExpiration;
        Matcher matcher = this.AttributeRegex().pattern().matcher(expiration);
        if (matcher.matches()) {
            String attribute2 = matcher.group(1);
            int i = sft.indexOf(attribute2);
            if (i == -1 || !Date.class.isAssignableFrom(sft.getDescriptor(i).getType().getBinding())) void var4_4;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid age-off attribute: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4})));
            featureExpiration = new FeatureExpiration.FeatureTimeExpiration(attribute2, i, this.duration(matcher.group(2)));
            return featureExpiration;
        } else {
            featureExpiration = new FeatureExpiration.IngestTimeExpiration(this.duration(expiration));
        }
        return featureExpiration;
    }

    public Option<String> unapply(FeatureExpiration expiration) {
        None$ none$;
        FeatureExpiration featureExpiration = expiration;
        if (featureExpiration instanceof FeatureExpiration.IngestTimeExpiration) {
            FeatureExpiration.IngestTimeExpiration ingestTimeExpiration = (FeatureExpiration.IngestTimeExpiration)featureExpiration;
            Duration duration2 = ingestTimeExpiration.ttl();
            none$ = new Some((Object)duration2.toString());
        } else if (featureExpiration instanceof FeatureExpiration.FeatureTimeExpiration) {
            FeatureExpiration.FeatureTimeExpiration featureTimeExpiration = (FeatureExpiration.FeatureTimeExpiration)featureExpiration;
            String attribute2 = featureTimeExpiration.attribute();
            Duration duration3 = featureTimeExpiration.ttl();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute2, duration3})));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Duration duration(String string2) {
        try {
            Duration duration2 = Duration$.MODULE$.apply(string2);
            if (duration2.isFinite()) {
                if (duration2.$less$eq((Object)Duration$.MODULE$.Zero())) {
                    throw new IllegalArgumentException("Duration is negative");
                }
                return duration2;
            }
            throw new IllegalArgumentException("Duration is infinite");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid age-off time-to-live: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2})), e);
        }
    }

    private FeatureExpiration$() {
        MODULE$ = this;
        this.AttributeRegex = new StringOps(Predef$.MODULE$.augmentString("([^()]+)\\((.+)\\)")).r();
    }
}

