/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileWriter;
import org.locationtech.geomesa.utils.geotools.AttributeDetails;
import org.locationtech.geomesa.utils.geotools.AttributeDetails$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.Nothing$;

public final class GenerateFeatureWrappers$ {
    public static final GenerateFeatureWrappers$ MODULE$;
    private final String className;

    static {
        new GenerateFeatureWrappers$();
    }

    public String className() {
        return this.className;
    }

    public String buildAllClasses(Seq<SimpleFeatureType> sfts2, String pkg) {
        StringBuilder sb = new StringBuilder();
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"package ", "\\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pkg})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"object ", " {"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className()})));
        sfts2.foreach((Function1)new Serializable(sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(SimpleFeatureType sft) {
                return this.sb$1.append("\n\n").append(GenerateFeatureWrappers$.MODULE$.buildClass(sft, "  "));
            }
            {
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n}");
        return sb.toString();
    }

    public String buildClass(SimpleFeatureType sft, String tab) {
        Buffer attrs = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final AttributeDetails apply(AttributeDescriptor x$2) {
                return AttributeDetails$.MODULE$.apply(x$2, this.sft$1);
            }
            {
                this.sft$1 = sft$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        StringBuilder sb = new StringBuilder();
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "implicit class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tab, sft.getTypeName()})));
        sb.append("(val sf: org.opengis.feature.simple.SimpleFeature) extends AnyVal {\n");
        attrs.foreach((Function1)new Serializable(tab, sb){
            public static final long serialVersionUID = 0L;
            private final String tab$1;
            private final StringBuilder sb$2;

            public final StringBuilder apply(AttributeDetails a) {
                this.sb$2.append("\n");
                this.sb$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "  ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tab$1, a.getter()})));
                this.sb$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "  ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tab$1, a.optionGetter()})));
                return this.sb$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "  ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tab$1, a.setter()})));
            }
            {
                this.tab$1 = tab$1;
                this.sb$2 = sb$2;
            }
        });
        sb.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "  def debug(): String = {\n        |", "    import scala.collection.JavaConversions._\n        |", "    val sb = new StringBuilder(s\"${sf.getType.getTypeName}:${sf.getID}\")\n        |", "    sf.getProperties.foreach(p => sb.append(s\"|${p.getName.getLocalPart}=${p.getValue}\"))\n        |", "    sb.toString()\n        |", "  }\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tab, tab, tab, tab, tab, tab})))).stripMargin());
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tab})));
        return sb.toString();
    }

    public Seq<File> findFormatFiles(File file) {
        String name2;
        return file.isDirectory() ? (Seq)Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File file) {
                return GenerateFeatureWrappers$.MODULE$.findFormatFiles(file);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : ((name2 = file.getName()).startsWith("format-") && name2.endsWith(".conf") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file})) : (Seq)Seq$.MODULE$.empty());
    }

    public void main(String[] args) {
        String basedir = args[0];
        String packageName = args[1];
        Predef$.MODULE$.assert(basedir != null);
        Predef$.MODULE$.assert(packageName != null);
        File folder = new File(new StringBuilder().append((Object)basedir).append((Object)"/src/main/resources").toString());
        Seq resources = (Seq)((SeqLike)new Some((Object)folder).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$3) {
                return x$3.isDirectory();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File file) {
                return GenerateFeatureWrappers$.MODULE$.findFormatFiles(file);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        })).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$4) {
                return x$4.getName();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        Seq sfts2 = (Seq)resources.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleFeatureType apply(File r) {
                return SimpleFeatureTypes$.MODULE$.createType(ConfigFactory.parseFile((File)r), SimpleFeatureTypes$.MODULE$.createType$default$2(), SimpleFeatureTypes$.MODULE$.createType$default$3());
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (sfts2.isEmpty()) {
            Predef$.MODULE$.println((Object)"No formats found");
        } else {
            String classFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/src/main/scala/", "/", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basedir, packageName.replaceAll("\\.", "/"), this.className()}));
            File classFile = new File(classFilePath);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing class file ", ".", " with formats ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packageName, this.className(), ((TraversableOnce)sfts2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SimpleFeatureType x$5) {
                    return x$5.getTypeName();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            FileWriter fw = new FileWriter(classFile);
            fw.write(this.buildAllClasses((Seq<SimpleFeatureType>)sfts2, packageName));
            fw.flush();
            fw.close();
        }
    }

    private GenerateFeatureWrappers$() {
        MODULE$ = this;
        this.className = "SimpleFeatureWrappers";
    }
}

