/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.locationtech.geomesa.utils.io.CompressionUtils;
import org.locationtech.geomesa.utils.io.CompressionUtils$;
import org.locationtech.geomesa.utils.io.PathUtils;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate$;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class PathUtils$
implements FileSystemDelegate {
    public static final PathUtils$ MODULE$;
    private final Pattern uriRegex;
    private final boolean hadoopAvailable;
    private final LocalDelegate localDelegate;
    private final HadoopDelegate hadoopDelegate;
    private final AtomicBoolean factorySet;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PathUtils$();
    }

    private Logger logger$lzycompute() {
        PathUtils$ pathUtils$ = this;
        synchronized (pathUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Pattern uriRegex() {
        return this.uriRegex;
    }

    private boolean hadoopAvailable() {
        return this.hadoopAvailable;
    }

    private LocalDelegate localDelegate() {
        return this.localDelegate;
    }

    private HadoopDelegate hadoopDelegate() {
        return this.hadoopDelegate;
    }

    private AtomicBoolean factorySet() {
        return this.factorySet;
    }

    private void configureURLFactory() {
        if (this.factorySet().compareAndSet(false, true)) {
            try {
                BoxedUnit boxedUnit;
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Configured Hadoop URL Factory.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Could not register Hadoop URL Factory. Some filesystems may not be available.");
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        return this.chooseDelegate(path).interpretPath(path);
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        return this.chooseDelegate(path).getHandle(path);
    }

    public boolean isRemote(String path) {
        return this.uriRegex().matcher(path).matches() && !path.toLowerCase().startsWith("file://");
    }

    public URL getUrl(String path) {
        try {
            URL uRL;
            if (this.uriRegex().matcher(path).matches()) {
                this.configureURLFactory();
                uRL = new URL(path);
            } else {
                uRL = new File(path).toURI().toURL();
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid URL ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), malformedURLException);
        }
    }

    public String getUncompressedExtension(String path) {
        return FilenameUtils.getExtension((String)CompressionUtils$.MODULE$.getUncompressedFilename(path));
    }

    public Tuple2<String, String> getBaseNameAndExtension(String path, boolean includeDot) {
        String withoutExtension;
        int secondSplit;
        int split = FilenameUtils.indexOfExtension((String)path);
        return split == -1 ? new Tuple2((Object)path, (Object)"") : ((secondSplit = FilenameUtils.indexOfExtension((String)(withoutExtension = path.substring(0, split)))) != -1 && CompressionUtils$.MODULE$.isCompressedFilename(path) ? new Tuple2((Object)path.substring(0, secondSplit), (Object)path.substring(this.dotIndex$1(secondSplit, includeDot))) : new Tuple2((Object)withoutExtension, (Object)path.substring(this.dotIndex$1(split, includeDot))));
    }

    public boolean getBaseNameAndExtension$default$2() {
        return true;
    }

    public InputStream handleCompression(InputStream is, String filename) {
        Option option2;
        block4: {
            InputStream inputStream;
            block3: {
                BufferedInputStream buffered;
                block2: {
                    buffered = new BufferedInputStream(is);
                    option2 = CompressionUtils$.MODULE$.Utils().find((Function1)new Serializable(filename){
                        public static final long serialVersionUID = 0L;
                        private final String filename$1;

                        public final boolean apply(CompressionUtils x$1) {
                            return x$1.isCompressedFilename(this.filename$1);
                        }
                        {
                            this.filename$1 = filename$1;
                        }
                    });
                    if (!None$.MODULE$.equals(option2)) break block2;
                    inputStream = buffered;
                    break block3;
                }
                if (!(option2 instanceof Some)) break block4;
                Some some = (Some)option2;
                CompressionUtils utils = (CompressionUtils)some.x();
                inputStream = utils.compress(buffered);
            }
            return inputStream;
        }
        throw new MatchError((Object)option2);
    }

    public void deleteRecursively(Path path) {
        Files.walkFileTree(path, new PathUtils.DeleteFileVisitor());
    }

    private FileSystemDelegate chooseDelegate(String path) {
        return this.hadoopAvailable() && this.uriRegex().matcher(path).matches() ? this.hadoopDelegate() : this.localDelegate();
    }

    private final int dotIndex$1(int base, boolean includeDot$1) {
        return includeDot$1 ? base : base + 1;
    }

    private PathUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.uriRegex = Pattern.compile("\\w+://.*");
        this.hadoopAvailable = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<Object> apply() {
                return Class.forName("org.apache.hadoop.conf.Configuration");
            }
        }).isSuccess();
        this.localDelegate = new LocalDelegate();
        this.hadoopDelegate = this.hadoopAvailable() ? new HadoopDelegate(HadoopDelegate$.MODULE$.$lessinit$greater$default$1()) : null;
        this.factorySet = new AtomicBoolean(false);
    }
}

