/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization$Persistence$;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import pureconfig.ConfigWriter$;
import pureconfig.Derivation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class MetadataSerialization$
implements MethodProfiling {
    public static final MetadataSerialization$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MetadataSerialization$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        MetadataSerialization$ metadataSerialization$ = this;
        synchronized (metadataSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void serialize(OutputStream out, package.Metadata metadata) {
        SimpleFeatureType x$2 = metadata.sft();
        boolean x$3 = false;
        boolean x$4 = true;
        Config sftConfig = SimpleFeatureTypes$.MODULE$.toConfig(x$2, x$4, x$3);
        MetadataSerialization.Persistence.PartitionSchemeConfig schemeConfig = new MetadataSerialization.Persistence.PartitionSchemeConfig(metadata.scheme().name(), (Map<String, String>)metadata.scheme().options());
        MetadataSerialization.Persistence.StoragePersistence persistence = new MetadataSerialization.Persistence.StoragePersistence(sftConfig, schemeConfig, metadata.encoding(), metadata.leafStorage());
        String data = (String)this.profile("Serialized storage configuration", (Function0)new Serializable(persistence){
            public static final long serialVersionUID = 0L;
            private final MetadataSerialization.Persistence.StoragePersistence persistence$1;

            public final String apply() {
                return ConfigWriter$.MODULE$.apply((Derivation)new Derivation.Successful(MetadataSerialization$Persistence$.MODULE$.StoragePersistenceConvert())).to((Object)this.persistence$1).render(package$.MODULE$.RenderOptions());
            }
            {
                this.persistence$1 = persistence$1;
            }
        });
        this.profile("Wrote storage configuration", (Function0)new Serializable(out, data){
            public static final long serialVersionUID = 0L;
            private final OutputStream out$1;
            private final String data$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.out$1.write(this.data$1.getBytes(StandardCharsets.UTF_8));
            }
            {
                this.out$1 = out$1;
                this.data$1 = data$1;
            }
        });
    }

    public package.Metadata deserialize(InputStream in) {
        MetadataSerialization.Persistence.StoragePersistence persistence = (MetadataSerialization.Persistence.StoragePersistence)this.profile("Parsed storage configuration", (Function0)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final MetadataSerialization.Persistence.StoragePersistence apply() {
                MetadataSerialization.Persistence.StoragePersistence storagePersistence;
                Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(this.in$1, StandardCharsets.UTF_8), (ConfigParseOptions)package$.MODULE$.ParseOptions());
                try {
                    storagePersistence = (MetadataSerialization.Persistence.StoragePersistence)pureconfig.package$.MODULE$.loadConfigOrThrow(config, ClassTag$.MODULE$.apply(MetadataSerialization.Persistence.StoragePersistence.class), (Derivation)new Derivation.Successful(MetadataSerialization$Persistence$.MODULE$.StoragePersistenceConvert()));
                }
                catch (Throwable throwable) {
                    MetadataSerialization.Persistence.StoragePersistence storagePersistence2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    MetadataSerialization.Persistence.StoragePersistenceV1 v1 = (MetadataSerialization.Persistence.StoragePersistenceV1)Try$.MODULE$.apply((Function0)new Serializable(this, config){
                        public static final long serialVersionUID = 0L;
                        private final Config config$1;

                        public final MetadataSerialization.Persistence.StoragePersistenceV1 apply() {
                            return (MetadataSerialization.Persistence.StoragePersistenceV1)pureconfig.package$.MODULE$.loadConfigOrThrow(this.config$1, ClassTag$.MODULE$.apply(MetadataSerialization.Persistence.StoragePersistenceV1.class), (Derivation)new Derivation.Successful(MetadataSerialization$Persistence$.MODULE$.StoragePersistenceV1Convert()));
                        }
                        {
                            this.config$1 = config$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Nothing$ apply() {
                            throw this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    boolean leaf = v1.partitionScheme().options().get((Object)"leaf-storage").forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$1) {
                            return x$1.equalsIgnoreCase("true");
                        }
                    });
                    storagePersistence = storagePersistence2 = new MetadataSerialization.Persistence.StoragePersistence(v1.featureType(), v1.partitionScheme(), v1.encoding(), leaf);
                }
                return storagePersistence;
            }
            {
                this.in$1 = in$1;
            }
        });
        SimpleFeatureType sft = (SimpleFeatureType)this.profile("Parsed simple feature type", (Function0)new Serializable(persistence){
            public static final long serialVersionUID = 0L;
            private final MetadataSerialization.Persistence.StoragePersistence persistence$2;

            public final SimpleFeatureType apply() {
                Config x$5 = this.persistence$2.featureType();
                None$ x$6 = None$.MODULE$;
                Option x$7 = SimpleFeatureTypes$.MODULE$.createType$default$2();
                return SimpleFeatureTypes$.MODULE$.createType(x$5, x$7, (Option)x$6);
            }
            {
                this.persistence$2 = persistence$2;
            }
        });
        package.NamedOptions scheme = new package.NamedOptions(persistence.partitionScheme().scheme(), persistence.partitionScheme().options());
        return new package.Metadata(sft, persistence.encoding(), scheme, persistence.leafStorage());
    }

    private MetadataSerialization$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
    }
}

