/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.util;

import java.util.ArrayList;
import java.util.List;
import org.geotools.util.Utilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class IntersectUtils {
    public static boolean intersects(Geometry g1, Geometry g2) {
        Utilities.ensureNonNull((String)"g1", (Object)g1);
        Utilities.ensureNonNull((String)"g2", (Object)g2);
        if (g1 instanceof GeometryCollection) {
            if (g2 instanceof GeometryCollection) {
                return IntersectUtils.intersects((GeometryCollection)g1, (GeometryCollection)g2);
            }
            return IntersectUtils.intersects((GeometryCollection)g1, g2);
        }
        if (g2 instanceof GeometryCollection) {
            return IntersectUtils.intersects((GeometryCollection)g2, g1);
        }
        return g1.intersects(g2);
    }

    private static boolean intersects(GeometryCollection gc, Geometry g) {
        int size = gc.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry g1 = gc.getGeometryN(i);
            if (!g1.intersects(g)) continue;
            return true;
        }
        return false;
    }

    private static boolean intersects(GeometryCollection gc1, GeometryCollection gc2) {
        int size = gc1.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry g1 = gc1.getGeometryN(i);
            if (!IntersectUtils.intersects(gc2, g1)) continue;
            return true;
        }
        return false;
    }

    public static Geometry intersection(Geometry g1, Geometry g2) {
        if (g1 instanceof GeometryCollection) {
            if (g2 instanceof GeometryCollection) {
                return IntersectUtils.intersection((GeometryCollection)g1, (GeometryCollection)g2);
            }
            List<Geometry> ret = IntersectUtils.intersection((GeometryCollection)g1, g2);
            return g1.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(ret));
        }
        if (g2 instanceof GeometryCollection) {
            List<Geometry> ret = IntersectUtils.intersection((GeometryCollection)g2, g1);
            return g1.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(ret));
        }
        return g1.intersection(g2);
    }

    private static List<Geometry> intersection(GeometryCollection gc, Geometry g) {
        ArrayList<Geometry> ret = new ArrayList<Geometry>();
        int size = gc.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry g1 = gc.getGeometryN(i);
            IntersectUtils.collect(g1.intersection(g), ret);
        }
        return ret;
    }

    private static GeometryCollection intersection(GeometryCollection gc1, GeometryCollection gc2) {
        ArrayList<Geometry> ret = new ArrayList<Geometry>();
        int size = gc1.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry g1 = gc1.getGeometryN(i);
            List<Geometry> partial = IntersectUtils.intersection(gc2, g1);
            ret.addAll(partial);
        }
        return gc1.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(ret));
    }

    private static void collect(Geometry g, List<Geometry> collector) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry loop = gc.getGeometryN(i);
                if (loop.isEmpty()) continue;
                collector.add(loop);
            }
        } else if (!g.isEmpty()) {
            collector.add(g);
        }
    }

    public static Geometry unrollGeometries(Geometry geometry) throws IllegalArgumentException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            return geometry;
        }
        if (geometry instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)geometry;
            return geometry.getFactory().createMultiPolygon(IntersectUtils.unrollGeometries(mp).toArray(new Polygon[0]));
        }
        if (geometry instanceof GeometryCollection) {
            ArrayList<Polygon> ret = new ArrayList<Polygon>();
            GeometryCollection gc = (GeometryCollection)geometry;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry g = gc.getGeometryN(i);
                if (g instanceof Polygon) {
                    ret.add((Polygon)g);
                    continue;
                }
                if (g instanceof MultiPolygon) {
                    ret.addAll(IntersectUtils.unrollGeometries((MultiPolygon)g));
                    continue;
                }
                throw new IllegalArgumentException(g.getClass().toString());
            }
            return geometry.getFactory().createMultiPolygon(ret.toArray(new Polygon[0]));
        }
        throw new IllegalArgumentException(geometry.getClass().toString());
    }

    private static List<Polygon> unrollGeometries(MultiPolygon mp) {
        ArrayList<Polygon> ret = new ArrayList<Polygon>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Polygon g = (Polygon)mp.getGeometryN(i);
            ret.add(g);
        }
        return ret;
    }
}

