/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.locationtech.geomesa.utils.io.HadoopUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HBaseConnectionPool$
implements LazyLogging {
    public static final HBaseConnectionPool$ MODULE$;
    private final LoadingCache<HBaseConnectionPool.ConfigKey, Configuration> configs;
    private final LoadingCache<Tuple2<Configuration, Object>, HBaseConnectionPool.CachedConnection> org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HBaseConnectionPool$();
    }

    private Logger logger$lzycompute() {
        HBaseConnectionPool$ hBaseConnectionPool$ = this;
        synchronized (hBaseConnectionPool$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private LoadingCache<HBaseConnectionPool.ConfigKey, Configuration> configs() {
        return this.configs;
    }

    public LoadingCache<Tuple2<Configuration, Object>, HBaseConnectionPool.CachedConnection> org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections() {
        return this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections;
    }

    public Configuration getConfiguration(Map<String, ?> params) {
        Option zk = HBaseDataStoreParams$.MODULE$.ZookeeperParam().lookupOpt(params);
        Option paths = HBaseDataStoreParams$.MODULE$.ConfigPathsParam().lookupOpt(params);
        Option xml = HBaseDataStoreParams$.MODULE$.ConfigsParam().lookupOpt(params);
        return (Configuration)this.configs().get((Object)new HBaseConnectionPool.ConfigKey((Option<String>)zk, (Option<String>)paths, (Option<String>)xml));
    }

    public HBaseConnectionPool.ConnectionWrapper getConnection(Map<String, ?> params, boolean validate) {
        HBaseConnectionPool.ConnectionWrapper connectionWrapper;
        if (HBaseDataStoreParams$.MODULE$.ConnectionParam().exists(params)) {
            connectionWrapper = new HBaseConnectionPool.ProvidedConnection((Connection)HBaseDataStoreParams$.MODULE$.ConnectionParam().lookup(params));
        } else {
            Configuration conf = this.getConfiguration(params);
            connectionWrapper = Predef$.MODULE$.Boolean2boolean((Boolean)HBaseDataStoreParams$.MODULE$.CacheConnectionsParam().lookup(params)) ? (HBaseConnectionPool.ConnectionWrapper)this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections().get((Object)new Tuple2((Object)conf, (Object)BoxesRunTime.boxToBoolean((boolean)validate))) : this.createConnection(conf, validate);
        }
        return connectionWrapper;
    }

    public HBaseConnectionPool.ConnectionWrapper createConnection(Configuration conf, boolean validate) {
        HBaseConnectionPool.ConnectionWrapper connectionWrapper;
        if (User.isHBaseSecurityEnabled((Configuration)conf)) {
            this.configureSecurity(conf);
            PrivilegedExceptionAction<HBaseConnectionPool.ConnectionWrapper> action = new PrivilegedExceptionAction<HBaseConnectionPool.ConnectionWrapper>(conf, validate){
                private final Configuration conf$3;
                private final boolean validate$1;

                public HBaseConnectionPool.ConnectionWrapper run() {
                    return HBaseConnectionPool$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$doCreateConnection(this.conf$3, this.validate$1);
                }
                {
                    this.conf$3 = conf$3;
                    this.validate$1 = validate$1;
                }
            };
            connectionWrapper = (HBaseConnectionPool.ConnectionWrapper)User.getCurrent().runAs((PrivilegedExceptionAction)action);
        } else {
            connectionWrapper = this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$doCreateConnection(conf, validate);
        }
        return connectionWrapper;
    }

    public HBaseConnectionPool.ConnectionWrapper org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$doCreateConnection(Configuration conf, boolean validate) {
        if (validate) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Checking configuration availability");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HBaseAdmin.checkHBaseAvailable((Configuration)conf);
        }
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        None$ kerberos = User.isHBaseSecurityEnabled((Configuration)conf) ? new Some((Object)HadoopUtils$.MODULE$.kerberosTicketRenewer()) : None$.MODULE$;
        return new HBaseConnectionPool.SingletonConnection(connection, (Option<Closeable>)kerberos);
    }

    public synchronized void configureSecurity(Configuration conf) {
        if (User.isHBaseSecurityEnabled((Configuration)conf)) {
            BoxedUnit boxedUnit;
            String principal = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal());
            String keytab = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Kerberos with principal '", "', keytab '", "', "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal, keytab}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and Hadoop authentication method '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecurityUtil.getAuthenticationMethod((Configuration)conf)}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            if (currentUser.hasKerberosCredentials() && this.sameName(currentUser, principal)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("User '{}' is already authenticated", new Object[]{principal});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit3;
                BoxedUnit boxedUnit4;
                if (currentUser.hasKerberosCredentials()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing global authenticated Hadoop user from '", "' to '", "' -"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentUser.getUserName(), principal}))).append((Object)"this will affect any connections still using the old user").toString());
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Logged into Hadoop with user '{}'", new Object[]{UserGroupInformation.getCurrentUser().getUserName()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            }
        }
    }

    private boolean sameName(UserGroupInformation current, String principal) {
        Try try_;
        block9: {
            String string;
            block6: {
                String string2;
                block8: {
                    BoxedUnit boxedUnit;
                    block7: {
                        block5: {
                            if (principal.indexOf(64) == -1) break block5;
                            string = SecurityUtil.getServerPrincipal((String)principal, null);
                            break block6;
                        }
                        try_ = Try$.MODULE$.apply((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return KerberosUtil.getDefaultRealm();
                            }
                        });
                        if (!(try_ instanceof Success)) break block7;
                        Success success = (Success)try_;
                        String realm = (String)success.value();
                        string2 = SecurityUtil.getServerPrincipal((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal, realm})), null);
                        break block8;
                    }
                    if (!(try_ instanceof Failure)) break block9;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Unable to get default Kerberos realm: {}", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string2 = principal.contains("_HOST") ? (String)new StringOps(Predef$.MODULE$.augmentString(SecurityUtil.getServerPrincipal((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "@foo"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal})), null))).dropRight(4) : principal;
                }
                string = string2;
            }
            String fullName = string;
            String string3 = current.getUserName();
            String string4 = fullName;
            return !(string3 != null ? !string3.equals(string4) : string4 != null);
        }
        throw new MatchError((Object)try_);
    }

    private HBaseConnectionPool$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.configs = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<HBaseConnectionPool.ConfigKey, Configuration>(){
            private Configuration configuration;
            private volatile boolean bitmap$0;

            /*
             * WARNING - void declaration
             */
            private Configuration configuration$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        void var2_2;
                        Configuration base = HBaseConfiguration.create();
                        HBaseDataStoreFactory$.MODULE$.ConfigPathProperty().option().foreach((Function1)new Serializable(this, base){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Configuration base$1;

                            public final void apply(String x$1) {
                                this.$outer.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$anon$$addResources(this.base$1, x$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.base$1 = base$1;
                            }
                        });
                        this.configuration = var2_2;
                        this.bitmap$0 = true;
                    }
                    return this.configuration;
                }
            }

            private Configuration configuration() {
                return this.bitmap$0 ? this.configuration : this.configuration$lzycompute();
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public Configuration load(HBaseConnectionPool.ConfigKey key) {
                void var2_2;
                BoxedUnit boxedUnit;
                Configuration conf = new Configuration(this.configuration());
                key.xml().foreach((Function1)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final Configuration conf$2;

                    public final void apply(String xml) {
                        this.conf$2.addResource((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                    }
                    {
                        this.conf$2 = conf$2;
                    }
                });
                key.paths().foreach((Function1)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final Configuration conf$2;

                    public final void apply(String x$2) {
                        this.$outer.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$anon$$addResources(this.conf$2, x$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conf$2 = conf$2;
                    }
                });
                key.zookeepers().foreach((Function1)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final Configuration conf$2;

                    public final void apply(String zk) {
                        this.conf$2.set("hbase.zookeeper.quorum", zk);
                    }
                    {
                        this.conf$2 = conf$2;
                    }
                });
                if (key.zookeepers().isEmpty()) {
                    String string = conf.get("hbase.zookeeper.quorum");
                    String string2 = "localhost";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        if (HBaseConnectionPool$.MODULE$.logger().underlying().isWarnEnabled()) {
                            HBaseConnectionPool$.MODULE$.logger().underlying().warn("HBase connection is set to localhost - this may indicate that 'hbase-site.xml' is not on the classpath");
                            boxedUnit = BoxedUnit.UNIT;
                            return var2_2;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        return var2_2;
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
                return var2_2;
            }

            public void org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$anon$$addResources(Configuration conf, String paths) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(paths)).split(',')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$3) {
                        return x$3.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$4) {
                        return x$4.isEmpty();
                    }
                })).foreach((Function1)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final Configuration conf$1;

                    public final void apply(String x$5) {
                        HadoopUtils$.MODULE$.addResource(this.conf$1, x$5);
                    }
                    {
                        this.conf$1 = conf$1;
                    }
                });
            }
        });
        this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<Tuple2<Configuration, Object>, HBaseConnectionPool.CachedConnection>(){

            public HBaseConnectionPool.CachedConnection load(Tuple2<Configuration, Object> key) {
                HBaseConnectionPool.ConnectionWrapper connectionWrapper = HBaseConnectionPool$.MODULE$.createConnection((Configuration)key._1(), key._2$mcZ$sp());
                if (connectionWrapper instanceof HBaseConnectionPool.SingletonConnection) {
                    HBaseConnectionPool.SingletonConnection singletonConnection = (HBaseConnectionPool.SingletonConnection)connectionWrapper;
                    Connection connection = singletonConnection.connection();
                    Option<Closeable> kerberos = singletonConnection.kerberos();
                    HBaseConnectionPool.CachedConnection cachedConnection = new HBaseConnectionPool.CachedConnection(connection, kerberos);
                    return cachedConnection;
                }
                throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected SingletonConnection but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionWrapper})));
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                CloseWithLogging$.MODULE$.apply((Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(HBaseConnectionPool$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connections().asMap().values()).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Closeable> apply(HBaseConnectionPool.CachedConnection x0$1) {
                        HBaseConnectionPool.CachedConnection cachedConnection = x0$1;
                        if (cachedConnection != null) {
                            Connection c = cachedConnection.connection();
                            Option<Closeable> k = cachedConnection.kerberos();
                            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Connection[]{c}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(k), Seq$.MODULE$.canBuildFrom());
                            return seq;
                        }
                        throw new MatchError((Object)cachedConnection);
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
            }
        });
    }
}

