/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;
import org.locationtech.geomesa.bigtable.spark.BigtableExtendedScanSplit;

public class BigtableTableRecordReader {
    public static final String LOG_PER_ROW_COUNT = "hbase.mapreduce.log.scanner.rowcount";
    private static final Log LOG = LogFactory.getLog(BigtableTableRecordReader.class);
    private static final String HBASE_COUNTER_GROUP_NAME = "HBase Counters";
    private ResultScanner scanner = null;
    private BigtableExtendedScan scan = null;
    private Table htable = null;
    private byte[] lastSuccessfulRow = null;
    private ImmutableBytesWritable key = null;
    private Result value = null;
    private TaskAttemptContext context = null;
    private Method getCounter = null;
    private long numStale = 0L;
    private long timestamp;
    private int rowcount;
    private boolean logScannerActivity = false;
    private int logPerRowCount = 100;

    public void restart() throws IOException {
        this.scan.setScanMetricsEnabled(true);
        if (this.scanner != null) {
            if (this.logScannerActivity) {
                LOG.info((Object)"Closing the previously opened scanner object.");
            }
            this.scanner.close();
        }
        this.scanner = this.htable.getScanner((Scan)this.scan);
        if (this.logScannerActivity) {
            LOG.info((Object)("Current scan=" + this.scan.toString()));
            this.timestamp = System.currentTimeMillis();
            this.rowcount = 0;
        }
    }

    protected static Method retrieveGetCounterWithStringsParams(TaskAttemptContext context) throws IOException {
        Method m = null;
        try {
            m = context.getClass().getMethod("getCounter", String.class, String.class);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for getCounter", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    public void setHTable(Table htable) {
        Configuration conf = htable.getConfiguration();
        this.logScannerActivity = conf.getBoolean("hbase.client.log.scanner.activity", false);
        this.logPerRowCount = conf.getInt(LOG_PER_ROW_COUNT, 100);
        this.htable = htable;
    }

    public void setScan(BigtableExtendedScan scan) {
        this.scan = scan;
    }

    public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
        BigtableExtendedScanSplit split = (BigtableExtendedScanSplit)inputsplit;
        this.scan = split.scan;
        if (context != null) {
            this.context = context;
            this.getCounter = BigtableTableRecordReader.retrieveGetCounterWithStringsParams(context);
        }
        this.restart();
    }

    public void close() {
        this.scanner.close();
        try {
            this.htable.close();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error closing table", (Throwable)ioe);
        }
    }

    public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Result getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = new ImmutableBytesWritable();
        }
        if (this.value == null) {
            this.value = new Result();
        }
        try {
            this.value = this.scanner.next();
            if (this.value != null && this.value.isStale()) {
                ++this.numStale;
            }
            if (this.logScannerActivity) {
                ++this.rowcount;
                if (this.rowcount >= this.logPerRowCount) {
                    long now = System.currentTimeMillis();
                    LOG.info((Object)("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows"));
                    this.timestamp = now;
                    this.rowcount = 0;
                }
            }
            if (this.value != null && this.value.size() > 0) {
                this.key.set(this.value.getRow());
                this.lastSuccessfulRow = this.key.get();
                return true;
            }
            this.updateCounters();
            return false;
        }
        catch (IOException ioe) {
            if (this.logScannerActivity) {
                long now = System.currentTimeMillis();
                LOG.info((Object)("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows"));
                LOG.info((Object)ioe);
                String lastRow = this.lastSuccessfulRow == null ? "null" : Bytes.toStringBinary((byte[])this.lastSuccessfulRow);
                LOG.info((Object)("lastSuccessfulRow=" + lastRow));
            }
            throw ioe;
        }
    }

    private void updateCounters() throws IOException {
        ScanMetrics scanMetrics = this.scan.getScanMetrics();
        if (scanMetrics == null) {
            return;
        }
        BigtableTableRecordReader.updateCounters(scanMetrics, this.getCounter, this.context, this.numStale);
    }

    protected static void updateCounters(ScanMetrics scanMetrics, Method getCounter, TaskAttemptContext context, long numStale) {
        if (getCounter == null) {
            return;
        }
        try {
            for (Map.Entry entry : scanMetrics.getMetricsMap().entrySet()) {
                Counter ct = (Counter)getCounter.invoke((Object)context, HBASE_COUNTER_GROUP_NAME, entry.getKey());
                ct.increment(((Long)entry.getValue()).longValue());
            }
            ((Counter)getCounter.invoke((Object)context, HBASE_COUNTER_GROUP_NAME, "NUM_SCAN_RESULTS_STALE")).increment(numStale);
        }
        catch (Exception e) {
            LOG.debug((Object)("can't update counter." + StringUtils.stringifyException((Throwable)e)));
        }
    }

    public float getProgress() {
        return 0.0f;
    }
}

