/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.locationtech.geomesa.bigtable.spark.BigtableInputFormat;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4Aa\u0003\u0007\u0001/!)!\t\u0001C\u0001\u0007\"9a\t\u0001b\u0001\n\u00139\u0005BB&\u0001A\u0003%\u0001\nC\u00056\u0001\u0001\u0007\t\u0019!C\u0005\u0019\"I\u0001\u000b\u0001a\u0001\u0002\u0004%I!\u0015\u0005\n5\u0002\u0001\r\u0011!Q!\n5CQa\u0017\u0001\u0005BqCQ!\u001c\u0001\u0005B9DQ\u0001\u001f\u0001\u0005BeDQa\u001f\u0001\u0005Bq\u0014!dR3p\u001b\u0016\u001c\u0018MQ5hi\u0006\u0014G.Z%oaV$hi\u001c:nCRT!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012\u0001\u00032jOR\f'\r\\3\u000b\u0005E\u0011\u0012aB4f_6,7/\u0019\u0006\u0003'Q\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!F\u0001\u0004_J<7\u0001A\n\u0005\u0001a\u0011\u0004\b\u0005\u0003\u001aA\tBS\"\u0001\u000e\u000b\u0005ma\u0012!C7baJ,G-^2f\u0015\tib$\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003?Q\ta!\u00199bG\",\u0017BA\u0011\u001b\u0005-Ie\u000e];u\r>\u0014X.\u0019;\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015b\u0012AA5p\u0013\t9CE\u0001\u0003UKb$\bCA\u00151\u001b\u0005Q#BA\u0016-\u0003\u0019\u0019\u0018.\u001c9mK*\u0011QFL\u0001\bM\u0016\fG/\u001e:f\u0015\tyC#A\u0004pa\u0016tw-[:\n\u0005ER#!D*j[BdWMR3biV\u0014X\r\u0005\u00024m5\tAG\u0003\u000269\u0005!1m\u001c8g\u0013\t9DG\u0001\u0007D_:4\u0017nZ;sC\ndW\r\u0005\u0002:\u00016\t!H\u0003\u0002<y\u0005a1oY1mC2|wmZ5oO*\u0011QHP\u0001\tif\u0004Xm]1gK*\tq(A\u0002d_6L!!\u0011\u001e\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"!\u0012\u0001\u000e\u00031\t\u0001\u0002Z3mK\u001e\fG/Z\u000b\u0002\u0011B\u0011Q)S\u0005\u0003\u00152\u00111CQ5hi\u0006\u0014G.Z%oaV$hi\u001c:nCR\f\u0011\u0002Z3mK\u001e\fG/\u001a\u0011\u0016\u00035\u0003\"a\r(\n\u0005=#$!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0005d_:4w\fJ3r)\t\u0011\u0006\f\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0003V]&$\bbB-\u0006\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014!B2p]\u001a\u0004\u0013!C4fiN\u0003H.\u001b;t)\ti\u0006\u000eE\u0002_G\u0016l\u0011a\u0018\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005\u0011a\u0015n\u001d;\u0011\u0005e1\u0017BA4\u001b\u0005)Ie\u000e];u'Bd\u0017\u000e\u001e\u0005\u0006S\u001e\u0001\rA[\u0001\bG>tG/\u001a=u!\tI2.\u0003\u0002m5\tQ!j\u001c2D_:$X\r\u001f;\u0002%\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u000b\u0004_J$\b\u0003B\rqE!J!!\u001d\u000e\u0003\u0019I+7m\u001c:e%\u0016\fG-\u001a:\t\u000bMD\u0001\u0019A3\u0002\u000bM\u0004H.\u001b;\t\u000b%D\u0001\u0019A;\u0011\u0005e1\u0018BA<\u001b\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\u000fM,GoQ8oMR\u0011!K\u001f\u0005\u0006k%\u0001\r!T\u0001\bO\u0016$8i\u001c8g)\u0005i\u0005")
public class GeoMesaBigtableInputFormat
extends InputFormat<Text, SimpleFeature>
implements Configurable,
LazyLogging {
    private final BigtableInputFormat delegate;
    private Configuration conf;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaBigtableInputFormat geoMesaBigtableInputFormat = this;
        synchronized (geoMesaBigtableInputFormat) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private BigtableInputFormat delegate() {
        return this.delegate;
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public List<InputSplit> getSplits(JobContext context) {
        void var2_2;
        BoxedUnit boxedUnit;
        List<InputSplit> splits = this.delegate().getSplits(context);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Got {} splits", new Object[]{BoxesRunTime.boxToInteger((int)splits.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public RecordReader<Text, SimpleFeature> createRecordReader(InputSplit split, TaskAttemptContext context) {
        QueryPlan.ResultsToFeatures toFeatures = GeoMesaConfigurator$.MODULE$.getResultsToFeatures(context.getConfiguration());
        Option reducer = GeoMesaConfigurator$.MODULE$.getReducer(context.getConfiguration());
        return new GeoMesaHBaseInputFormat.GeoMesaHBaseRecordReader(toFeatures, reducer, this.delegate().createRecordReader(split, context));
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(conf);
        this.delegate().setConf(conf);
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
    }

    public Configuration getConf() {
        return this.conf();
    }

    public GeoMesaBigtableInputFormat() {
        LazyLogging.$init$((LazyLogging)this);
        this.delegate = new BigtableInputFormat();
    }
}

