/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.locationtech.geomesa.bigtable.spark.BigtableInputFormatBase;

public class BigtableExtendedScanSplit
extends InputSplit
implements Writable,
Comparable<BigtableExtendedScanSplit> {
    public BigtableExtendedScan scan;
    public TableName name;

    public BigtableExtendedScanSplit(TableName name, BigtableExtendedScan scan) {
        this.name = name;
        this.scan = scan;
    }

    public BigtableExtendedScanSplit() {
    }

    public long getLength() throws IOException, InterruptedException {
        return 1000L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[]{""};
    }

    @Override
    public int compareTo(BigtableExtendedScanSplit o) {
        int tableNameComparison = this.name.compareTo(o.name);
        return tableNameComparison != 0 ? tableNameComparison : Bytes.compareTo((byte[])this.scan.getRowSet().getRowRanges(0).getStartKeyClosed().toByteArray(), (byte[])o.scan.getRowSet().getRowRanges(0).getStartKeyClosed().toByteArray());
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray((DataOutput)out, (byte[])this.name.getName());
        Bytes.writeByteArray((DataOutput)out, (byte[])BigtableInputFormatBase.scanToString(this.scan).getBytes());
    }

    public void readFields(DataInput in) throws IOException {
        this.name = TableName.valueOf((byte[])Bytes.readByteArray((DataInput)in));
        this.scan = BigtableInputFormatBase.stringToScan(Bytes.toString((byte[])Bytes.readByteArray((DataInput)in)));
    }
}

